/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.managers;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mw.nullcore.NullCore;
import com.mw.nullcore.Utils;
import com.mw.nullcore.core.builders.CommandBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;

public final class ConfigManager {
    private static Initialize INSTANCE;
    public static Map<String, Set<Initialize.Unit<?>>> variables;

    public static void register(String modid, Path configDir, Runnable registers, boolean createCommand) {
        Path configPath = configDir.resolve(modid + ".json");
        INSTANCE = new Initialize(configPath, modid);
        registers.run();
        INSTANCE.load();
        if (createCommand) {
            CommandBuilder.builder(modid).requires(0).then((LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"config").then(Commands.argument((String)"unit", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> ConfigManager.suggestCommandUnits(modid, builder)).then(Commands.argument((String)"value", (ArgumentType)StringArgumentType.string()).executes(ctx -> ConfigManager.setCommandValue((CommandSourceStack)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"unit"), StringArgumentType.getString((CommandContext)ctx, (String)"value"))))))).register();
        }
    }

    public static void register(String modid, Path configDir, Runnable registers) {
        ConfigManager.register(modid, configDir, registers, false);
    }

    public static <V> Initialize.Unit<V> create(String key, String comment, V defaultValue) {
        Initialize.Unit<V> unit = Initialize.Unit.of(key, comment, defaultValue);
        ConfigManager.INSTANCE.config.put(key, unit);
        variables.computeIfAbsent(ConfigManager.INSTANCE.modid, k -> new HashSet()).add(unit);
        return unit;
    }

    public static <V> Initialize.Unit<V> getUnit(String key) {
        return ConfigManager.INSTANCE.config.get(key);
    }

    public static <V> void set(Initialize.Unit<V> unit, V value) {
        if (unit != null) {
            ConfigManager.INSTANCE.config.put(unit.name(), unit);
            unit.set(value);
            INSTANCE.save();
        }
    }

    public static <V> void set(String key, V value) {
        ConfigManager.set(ConfigManager.getUnit(key), value);
    }

    public static CompletableFuture<Suggestions> suggestCommandUnits(String modid, SuggestionsBuilder builder) {
        variables.get(modid).forEach(r -> builder.suggest(r.name()));
        return builder.buildFuture();
    }

    public static <V> int setCommandValue(CommandSourceStack source, String unit, String value) {
        Initialize.Unit<V> un = ConfigManager.getUnit(unit);
        if (un == null || un.value == un.parseValue(value)) {
            source.sendFailure((Component)Component.translatable((String)"message.nullcore.commandset.fail"));
            return 0;
        }
        ConfigManager.set(un, un.parseValue(value));
        source.sendSuccess(() -> Component.translatable((String)"message.nullcore.commandset.success"), false);
        return 1;
    }

    static {
        variables = new HashMap();
    }

    public static final class Initialize {
        public final Map<String, Unit<?>> config = new LinkedHashMap();
        private final Path configPath;
        public final String modid;

        public Initialize(Path configPath, String modid) {
            this.configPath = configPath;
            this.modid = modid;
        }

        void load() {
            if (!Files.exists(this.configPath, new LinkOption[0])) {
                this.save();
                return;
            }
            try {
                String content = Files.readString(this.configPath);
                JsonObject json = JsonParser.parseString((String)content).getAsJsonObject();
                for (Map.Entry entry : json.entrySet()) {
                    String key = (String)entry.getKey();
                    if (key.startsWith("_")) continue;
                    JsonElement element = (JsonElement)entry.getValue();
                    if (!this.config.containsKey(key)) continue;
                    this.updateConfig(key, element);
                }
            }
            catch (Exception e) {
                NullCore.LOG.error("Failed to load config: {}", (Object)e.getMessage());
            }
        }

        private void updateConfig(String key, JsonElement element) {
            Unit<?> unit = this.config.get(key);
            Object newValue = Utils.Reader.parseJsonValue(element, unit.get());
            if (newValue != null) {
                ConfigManager.set(key, newValue);
            }
        }

        void save() {
            JsonObject json = new JsonObject();
            ArrayList<String> keys = new ArrayList<String>(this.config.keySet());
            for (String key : keys) {
                Unit<?> unit = this.config.get(key);
                json.addProperty("comment_" + key, unit.comment());
                Utils.Reader.addValueToJson(json, key, unit.get());
            }
            try {
                String jsonString = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json);
                jsonString = jsonString.replaceAll("(\": [^,]+,\\n)(\\s+\"comment_)", "$1  \n$2");
                Files.writeString(this.configPath, (CharSequence)jsonString, new OpenOption[0]);
            }
            catch (Exception e) {
                NullCore.LOG.error("Failed to save config: {}", (Object)e.getMessage());
            }
        }

        public static class Unit<V> {
            final String comment;
            final String name;
            V value;

            private Unit(String name, String comment, V value) {
                this.value = value;
                this.name = name;
                this.comment = comment;
            }

            public static <V> Unit<V> of(String name, String comment, V value) {
                return new Unit<V>(name, comment, value);
            }

            public V get() {
                return this.value;
            }

            public void set(V value) {
                this.value = value;
            }

            public String comment() {
                return this.comment;
            }

            public String name() {
                return this.name;
            }

            public V parseValue(String value) {
                if (this.get() instanceof Boolean) {
                    return (V)Boolean.valueOf(value);
                }
                if (this.get() instanceof Byte) {
                    return (V)Byte.valueOf(value);
                }
                if (this.get() instanceof Integer) {
                    return (V)Integer.valueOf(value);
                }
                if (this.get() instanceof Float) {
                    return (V)Float.valueOf(value);
                }
                if (this.get() instanceof Double) {
                    return (V)Double.valueOf(value);
                }
                if (this.get() instanceof String) {
                    return (V)value;
                }
                return null;
            }
        }
    }
}

