/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mw.nullcore.NullCore;
import com.mw.nullcore.client.audio.TrackerController;
import com.mw.nullcore.core.blocks.type.ContainerBlockEntity;
import com.mw.nullcore.core.builders.ArmorMaterialBuilder;
import com.mw.nullcore.core.builders.GuiRenderBuilder;
import com.mw.nullcore.core.entities.ShyItemEntity;
import com.mw.nullcore.platform.Platform;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_52;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_7926;
import net.minecraft.class_8567;
import net.minecraft.class_8779;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class Utils {
    @NotNull
    public static final class_310 mc = class_310.method_1551();
    public static final class_5819 rand = class_5819.method_43053();
    @NotNull
    public static final class_327 font = Utils.mc.field_1772;
    public static final float partialTick = mc.method_61966().method_60637(false);
    public static int clientTick;

    public static boolean isClient() {
        return Platform.PLATFORM.isClient();
    }

    public static final class Reader {
        public static Object parseJsonValue(JsonElement element, Object defaultValue) {
            if (defaultValue instanceof Boolean) {
                return element.getAsBoolean();
            }
            if (defaultValue instanceof Integer) {
                return element.getAsInt();
            }
            if (defaultValue instanceof Byte) {
                return element.getAsByte();
            }
            if (defaultValue instanceof Short) {
                return element.getAsShort();
            }
            if (defaultValue instanceof Long) {
                return element.getAsLong();
            }
            if (defaultValue instanceof Float) {
                return Float.valueOf(element.getAsFloat());
            }
            if (defaultValue instanceof String) {
                return element.getAsString();
            }
            if (defaultValue instanceof Character) {
                return Character.valueOf(element.getAsCharacter());
            }
            return null;
        }

        public static void addValueToJson(JsonObject json, String key, Object value) {
            if (value instanceof Boolean) {
                json.addProperty(key, (Boolean)value);
            } else if (value instanceof Number) {
                json.addProperty(key, (Number)value);
            } else if (value instanceof String) {
                json.addProperty(key, (String)value);
            } else if (value instanceof Character) {
                json.addProperty(key, (Character)value);
            }
        }
    }

    public static final class Level {
        public static void setBiome(class_3218 level, class_5321<class_1959> biome, class_2338 from, class_2338 to) {
            class_7926.method_55339((class_3218)level, (class_2338)from, (class_2338)to, Level.getBiome((class_1937)level, biome));
        }

        public static void setBiome(class_3218 level, class_5321<class_1959> biome, class_2338 pos) {
            Level.setBiome(level, biome, pos, pos);
        }

        public static class_6880<class_1959> getBiome(class_1937 level, class_5321<class_1959> biome) {
            return level.method_30349().method_30530(class_7924.field_41236).method_46747(biome);
        }

        public static class_2960 getBiome(class_1937 level, class_1959 biome) {
            return level.method_30349().method_30530(class_7924.field_41236).method_10221((Object)biome);
        }

        public static List<class_2960> getStructuresAt(class_3218 level, class_2338 pos) {
            class_2378 structureRegistry = level.method_30349().method_30530(class_7924.field_41246);
            return level.method_27056().method_41037(pos).keySet().stream().map(arg_0 -> ((class_2378)structureRegistry).method_10221(arg_0)).filter(Objects::nonNull).toList();
        }

        public static boolean isStructure(class_1937 level, class_2338 pos, class_2960 structureId) {
            if (!(level instanceof class_3218)) {
                return false;
            }
            class_3218 sl = (class_3218)level;
            class_2378 registry = sl.method_30349().method_30530(class_7924.field_41246);
            class_3195 structure = (class_3195)registry.method_63535(structureId);
            if (structure == null) {
                return false;
            }
            return sl.method_27056().method_28388(pos, structure).method_16657();
        }

        public static List<class_1297> getEntities(class_1937 level, class_2338 startPos, double radius) {
            return level.method_8335(null, new class_238((double)startPos.method_10263() - radius, (double)startPos.method_10264() - radius, (double)startPos.method_10260() - radius, (double)startPos.method_10263() + radius, (double)startPos.method_10264() + radius, (double)startPos.method_10260() + radius));
        }
    }

    public static final class Text {
        public static void addTooltipWithKey(int button, int colorButton, List<class_2561> adder, class_2561 ... components) {
            if (class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)button)) {
                for (class_2561 cm : components) {
                    if (cm == null) continue;
                    adder.add(cm);
                }
            } else {
                adder.add((class_2561)class_2561.method_43469((String)"tooltip.nullcore.info", (Object[])new Object[]{class_2561.method_43471((String)class_3675.method_15985((int)button, (int)0).toString()).method_54663(colorButton)}));
            }
        }

        public static String formatNum(float amount) {
            float scaledNumber;
            String[] sufx = new String[]{"", "K", "M", "B", "T", "Qa", "Qt", "Sx", "Sp", "Oc", "N", "D"};
            int suffixIndex = 0;
            for (scaledNumber = amount; scaledNumber >= 1000.0f && suffixIndex < sufx.length - 1; scaledNumber /= 1000.0f, ++suffixIndex) {
            }
            DecimalFormat df = new DecimalFormat("#.#");
            return df.format(scaledNumber) + sufx[suffixIndex];
        }

        public static class_2561 addGradientText(String text, float time, int ... colors) {
            class_5819 rand = class_5819.method_43049((long)1L);
            float offset = -(((float)clientTick + partialTick) * rand.method_43057() + 0.5f) * time;
            class_5250 component = class_2561.method_43473();
            int length = text.length();
            if (length == 0 || colors.length == 0) {
                return component;
            }
            if ((offset %= 1.0f) < 0.0f) {
                offset += 1.0f;
            }
            for (int i = 0; i < length; ++i) {
                float pos = (float)i / (float)length + offset;
                float colorPos = (pos %= 1.0f) * (float)(colors.length - 1);
                int colorIndex = (int)colorPos;
                float lerp = colorPos - (float)colorIndex;
                int color1 = colors[colorIndex % colors.length];
                int color2 = colors[(colorIndex + 1) % colors.length];
                int color = Color.lerpColors(lerp, color1, color2);
                component.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(text.charAt(i))).method_27694(style -> style.method_36139(color)));
            }
            return component;
        }

        public static class_2561 addGradientText(class_2561 text, float time, int ... colors) {
            return Text.addGradientText(text.getString(), time, colors);
        }

        public static void sendMessage(class_1657 player, class_2561 key) {
            if (key != null) {
                player.method_7353(key, true);
            }
        }

        public static void addPositionTooltip(List<class_2561> tooltip, class_2338 pos, class_2561 key, int colorPos, int colorData) {
            if (pos != null) {
                tooltip.add((class_2561)key.method_27661().method_54663(colorPos));
                tooltip.add((class_2561)class_2561.method_43470((String)String.format("X: %d, Y: %d, Z: %d", pos.method_10263(), pos.method_10264(), pos.method_10260())).method_54663(colorData));
            }
        }

        public static void addTooltipEffects(List<class_2561> tooltip, class_5250 component, List<ArmorMaterialBuilder.ShyEffect> list) {
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    class_1291 effect = (class_1291)list.get(i).effect().comp_349();
                    String effectName = effect.method_5560().getString();
                    component.method_10852((class_2561)class_2561.method_43470((String)effectName).method_54663(effect.method_5556()));
                    if (i >= list.size() - 1) continue;
                    component.method_10852((class_2561)class_2561.method_43470((String)", ").method_27696(component.method_10866()));
                }
                tooltip.add((class_2561)component);
            }
        }
    }

    public static final class Render {
        public static final class_4597 mBuffer = mc.method_22940().method_23000();

        public static void drawTexture(class_332 gg, class_2960 texture, int x, int y, int u, int v, int pixelWidth, int pixelHeight, int width, int height, int color) {
            gg.method_25291(class_1921::method_62277, texture, x, y, (float)u, (float)v, pixelWidth, pixelHeight, width, height, color);
        }

        public static void drawTexture(class_332 gg, class_2960 texture, int x, int y, int u, int v, int pixelWidth, int pixelHeight, int width, int height) {
            Render.drawTexture(gg, texture, x, y, u, v, pixelWidth, pixelHeight, width, height, -1);
        }

        public static void drawLine(class_4587 ps, class_4588 buffer, float x1, float y1, float z1, float x2, float y2, float z2, int color, float width) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth((float)width);
            class_4587.class_4665 pose = ps.method_23760();
            buffer.method_22918(pose.method_23761(), x1, y1, z1).method_39415(color);
            buffer.method_22918(pose.method_23761(), x2, y2, z2).method_39415(color);
            RenderSystem.disableBlend();
        }

        public static void drawText(class_332 gg, Object text, int x, int y, int color, boolean shadow) {
            String string;
            if (text instanceof class_2561) {
                class_2561 c = (class_2561)text;
                string = c.getString();
            } else {
                string = text.toString();
            }
            String str = string;
            gg.method_51433(font, str, x, y, color, shadow);
        }

        public static void renderRays(class_4587 ps, class_4588 buffer, int color, float time, float pTick) {
            ps.method_22903();
            class_5819 rand = class_5819.method_43049((long)1L);
            float rotationTime = (((float)clientTick + pTick) * rand.method_43057() + 0.5f) * time;
            float[] rgb = Color.unpack(color, false);
            int count = rand.method_43051(10, 25);
            Vector3f center = new Vector3f(0.0f, 0.0f, 0.0f);
            for (int l = 0; l < count; ++l) {
                float length = rand.method_43057();
                float width = rand.method_43057() * 0.3f;
                Vector3f left = new Vector3f(-0.866f * width, length, -0.5f * width);
                Vector3f right = new Vector3f(0.866f * width, length, -0.5f * width);
                Vector3f front = new Vector3f(0.0f, length, width);
                Quaternionf rotate = new Quaternionf().rotationXYZ(rand.method_43057() * ((float)Math.PI * 2) + rotationTime * 0.05f, (float)Math.PI * 2 + rotationTime * 0.08f, rand.method_43057() * ((float)Math.PI * 2)).rotateXYZ(rand.method_43057() * ((float)Math.PI * 2), rand.method_43057() * ((float)Math.PI * 2), rand.method_43057() * ((float)Math.PI * 2) + rotationTime * 0.06f);
                ps.method_22907(rotate);
                class_4587.class_4665 pose = ps.method_23760();
                buffer.method_61032(pose, center).method_22915(1.0f, rgb[1] - 0.2f, rgb[2] - 0.2f, 1.0f);
                buffer.method_61032(pose, left).method_22915(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.method_61032(pose, right).method_22915(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.method_61032(pose, center).method_22915(1.0f, rgb[1] - 0.2f, rgb[2] - 0.2f, 1.0f);
                buffer.method_61032(pose, right).method_22915(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.method_61032(pose, front).method_22915(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.method_61032(pose, center).method_22915(1.0f, rgb[1] - 0.2f, rgb[2] - 0.2f, 1.0f);
                buffer.method_61032(pose, front).method_22915(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.method_61032(pose, left).method_22915(rgb[0], rgb[1], rgb[2], 0.0f);
                ps.method_22907(rotate.invert());
            }
            ps.method_22909();
        }

        public static float getAnimationTick(float pTick) {
            return pTick + (float)clientTick;
        }

        public static float getAnimationTick() {
            return Render.getAnimationTick(partialTick);
        }

        public static class_1058 getSprite(class_2960 texture) {
            class_1059 atlas = class_310.method_1551().method_1554().method_24153(GuiRenderBuilder.BLOCK_ATLAS);
            return atlas.method_4608(texture);
        }
    }

    public static final class Particle {
        public static void forParticleSpawn(class_1937 level, class_2394 particle, float pX, float pY, float pZ, float xSpeed, float ySpeed, float zSpeed, int count) {
            class_5819 rand = level.field_9229;
            for (int i = 0; i < count; ++i) {
                double oX = (rand.method_43058() - 0.5) * 0.5;
                double oY = (rand.method_43058() - 0.5) * 0.5;
                double oZ = (rand.method_43058() - 0.5) * 0.5;
                level.method_8406(particle, (double)pX + oX, (double)pY + oY, (double)pZ + oZ, (double)xSpeed, (double)ySpeed, (double)zSpeed);
            }
        }

        public static void forParticleSpawn(class_1937 level, class_2394 particle, float pX, float pY, float pZ, int count) {
            Particle.forParticleSpawn(level, particle, pX, pY, pZ, 0.0f, 0.0f, 0.0f, count);
        }

        public static void writeParticle(class_2487 tag, class_2394 particle) {
            class_2487 pTag = new class_2487();
            class_2960 loc = class_7923.field_41180.method_10221((Object)particle.method_10295());
            pTag.method_10582("namespace", loc.method_12836());
            pTag.method_10582("path", loc.method_12832());
            tag.method_10566("particle", (class_2520)pTag);
        }

        public static class_2394 readParticle(class_2487 tag) {
            class_2487 pTag = (class_2487)tag.method_10580("particle");
            return (class_2394)class_7923.field_41180.method_17966(class_2960.method_60655((String)pTag.method_10558("namespace"), (String)pTag.method_10558("path"))).get();
        }
    }

    public static final class Mth {
        public static boolean chance(float chance) {
            return rand.method_43057() < class_3532.method_15363((float)chance, (float)0.0f, (float)1.0f);
        }

        public static String formatRealTime(long gameTime) {
            long totalSeconds = gameTime / 20L;
            long hours = totalSeconds / 3600L;
            long minutes = totalSeconds % 3600L / 60L;
            long seconds = totalSeconds % 60L;
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }

        public static float perlinNoise(float x, float y, float z, float frequency, float amplitude) {
            float noise = 0.0f;
            for (int i = 0; i < 3; ++i) {
                noise += (float)(Math.sin(x * frequency) * Math.cos(y * frequency) * (z != 0.0f ? Math.sin(z * frequency) : 1.0) * (double)amplitude);
                frequency *= 2.0f;
                amplitude *= 0.4f;
            }
            return noise;
        }

        public static int secondTick(int seconds) {
            return seconds * 20;
        }

        public static int minuteTick(int minutes) {
            return Mth.secondTick(minutes * 60);
        }

        public static int hourTick(int hours) {
            return Mth.minuteTick(hours * 60);
        }

        public static int dayTick(int days) {
            return Mth.hourTick(days * 24);
        }
    }

    public static final class Color {
        public static float[] unpack(int color, boolean asARGB) {
            float[] fArray;
            if (asARGB) {
                float[] fArray2 = new float[4];
                fArray2[0] = (float)(color >> 16 & 0xFF) / 255.0f;
                fArray2[1] = (float)(color >> 8 & 0xFF) / 255.0f;
                fArray2[2] = (float)(color & 0xFF) / 255.0f;
                fArray = fArray2;
                fArray2[3] = (float)(color >> 24 & 0xFF) / 255.0f;
            } else {
                float[] fArray3 = new float[4];
                fArray3[0] = (float)(color >> 24 & 0xFF) / 255.0f;
                fArray3[1] = (float)(color >> 16 & 0xFF) / 255.0f;
                fArray3[2] = (float)(color >> 8 & 0xFF) / 255.0f;
                fArray = fArray3;
                fArray3[3] = (float)(color & 0xFF) / 255.0f;
            }
            return fArray;
        }

        public static int pack(float r, float g, float b, float a, boolean asARGB) {
            return asARGB ? (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f) : (int)(r * 255.0f) << 24 | (int)(g * 255.0f) << 16 | (int)(b * 255.0f) << 8 | (int)(a * 255.0f);
        }

        public static int hexPack(String hexColor) {
            if (((String)hexColor).startsWith("#")) {
                hexColor = ((String)hexColor).substring(1);
            }
            if (((String)hexColor).length() == 6) {
                hexColor = "FF" + (String)hexColor;
            }
            return (int)Long.parseLong((String)hexColor, 16);
        }

        public static int lerpColors(float progress, int ... colors) {
            float segment = progress * (float)(colors.length - 1);
            int index = (int)segment;
            float factor = segment - (float)index;
            if (index >= colors.length - 1) {
                index = colors.length - 2;
                factor = 1.0f;
            }
            float[] c1 = Color.unpack(colors[index], false);
            float[] c2 = Color.unpack(colors[index + 1], false);
            return Color.pack(class_3532.method_16439((float)factor, (float)c1[0], (float)c2[0]), class_3532.method_16439((float)factor, (float)c1[1], (float)c2[1]), class_3532.method_16439((float)factor, (float)c1[2], (float)c2[2]), class_3532.method_16439((float)factor, (float)c1[3], (float)c2[3]), false);
        }

        public static int getCyclingColor(float speed, int ... colors) {
            float time = Render.getAnimationTick() * speed;
            return Color.lerpColors((class_3532.method_15374((float)time) + 1.0f) / 2.0f, colors);
        }

        public static int getRainbow(float speed) {
            int[] rainbow = new int[36];
            for (int i = 0; i < rainbow.length; ++i) {
                rainbow[i] = java.awt.Color.HSBtoRGB((float)i / 36.0f, 1.0f, 1.0f) & 0xFFFFFF;
            }
            return Color.getCyclingColor(speed, rainbow);
        }
    }

    public static final class Client {
        public static void setSafeScreen(class_437 screen) {
            try {
                if (!mc.method_18854()) {
                    mc.execute(() -> Client.setSafeScreen(screen));
                    return;
                }
                if (Utils.mc.field_1687 == null || Utils.mc.field_1724 == null) {
                    return;
                }
                if (!Utils.mc.field_1687.method_8608()) {
                    return;
                }
                mc.method_1507(screen);
            }
            catch (Exception e) {
                NullCore.LOG.error("Error launching {}, {}", (Object)screen.getClass().getName(), (Object)e.getMessage());
            }
        }

        public static void tickClient() {
            if (!mc.method_1493()) {
                TrackerController.tick();
                ++clientTick;
            }
        }

        public static boolean checkAdvancement(class_3222 player, class_2960 id) {
            class_8779 advancement = player.field_13995.method_3851().method_12896(id);
            return advancement != null && player.method_14236().method_12882(advancement).method_740();
        }
    }

    public static final class Item {
        public static class_2371<class_1799> inventoryToList(class_1263 inv) {
            class_2371 list = class_2371.method_10213((int)inv.method_5439(), (Object)class_1799.field_8037);
            for (int i = 0; i < inv.method_5439(); ++i) {
                list.set(i, (Object)inv.method_5438(i).method_7972());
            }
            return list;
        }

        public static boolean insertItem(ContainerBlockEntity be, class_1657 player, int slot, int maxTransfer) {
            class_1277 inventory = be.getInventory();
            class_1799 slotStack = inventory.method_5438(slot);
            class_1799 heldStack = player.method_6047();
            int actualMax = Math.min(maxTransfer, be.maxInSlot);
            if (heldStack.method_7960()) {
                if (!slotStack.method_7960()) {
                    int transferAmount = Math.min(slotStack.method_7947(), actualMax);
                    class_1799 toGive = slotStack.method_7972();
                    toGive.method_7939(transferAmount);
                    if (!player.method_37908().method_8608()) {
                        ShyItemEntity entity = new ShyItemEntity(player.method_37908(), player.method_23312(), toGive, false);
                        entity.spawn();
                    }
                    slotStack.method_7934(transferAmount);
                    if (slotStack.method_7960()) {
                        inventory.method_5447(slot, class_1799.field_8037);
                    } else {
                        inventory.method_5447(slot, slotStack);
                    }
                    return true;
                }
            } else {
                if (slotStack.method_7960()) {
                    int transferAmount = Math.min(heldStack.method_7947(), actualMax);
                    class_1799 toInsert = heldStack.method_7972();
                    toInsert.method_7939(transferAmount);
                    inventory.method_5447(slot, toInsert);
                    heldStack.method_7934(transferAmount);
                    return true;
                }
                if (class_1799.method_7984((class_1799)slotStack, (class_1799)heldStack)) {
                    int spaceAvailable = Math.min(be.maxInSlot, slotStack.method_7914()) - slotStack.method_7947();
                    int transferAmount = Math.min(Math.min(heldStack.method_7947(), spaceAvailable), actualMax);
                    if (transferAmount > 0) {
                        slotStack.method_7933(transferAmount);
                        heldStack.method_7934(transferAmount);
                        inventory.method_5447(slot, slotStack);
                        return true;
                    }
                }
            }
            return false;
        }

        public static class_52 getLootTable(class_3218 level, class_5321<class_52> id) {
            return level.method_8503().method_58576().method_58295(id);
        }

        public static class_8567 getGiftParams(class_3218 level, class_243 pos, class_1297 entity, float luck) {
            return new class_8567.class_8568(level).method_51874(class_181.field_1226, (Object)entity).method_51874(class_181.field_24424, (Object)pos).method_51871(luck).method_51875(class_173.field_16235);
        }

        public static List<class_1799> createLoot(class_5321<class_52> id, class_8567 params) {
            class_52 loot = Item.getLootTable(params.method_51863(), id);
            if (loot == class_52.field_948) {
                return Lists.newArrayList();
            }
            return loot.method_51878(params);
        }

        public static void giveLoot(class_1657 player, List<class_1799> items) {
            for (class_1799 stack : items) {
                if (player.method_31548().method_7394(stack)) continue;
                player.method_7328(stack, false);
            }
        }

        public static void spawnLoot(class_1937 level, class_2338 pPos, Collection<class_1799> items) {
            if (!level.method_8608()) {
                for (class_1799 stack : items) {
                    level.method_8649((class_1297)new class_1542(level, (double)((float)pPos.method_10263() + 0.5f), (double)((float)pPos.method_10264() + 0.5f), (double)((float)pPos.method_10260() + 0.5f), stack));
                }
            }
        }
    }

    public static final class Block {
        public static void forEachCube(class_2338 center, int radius, Consumer<class_2338> action) {
            Block.forEachInVolume(center, radius, radius, radius, pos -> true, action);
        }

        public static void forEachSphere(class_2338 center, int radius, Consumer<class_2338> action) {
            int radiusSq = radius * radius;
            Block.forEachInVolume(center, radius, radius, radius, pos -> {
                int dz;
                int dy;
                int dx = pos.method_10263() - center.method_10263();
                return dx * dx + (dy = pos.method_10264() - center.method_10264()) * dy + (dz = pos.method_10260() - center.method_10260()) * dz <= radiusSq;
            }, action);
        }

        public static void forEachCircle(class_2338 center, int radius, int height, Consumer<class_2338> action) {
            int radiusSq = radius * radius;
            Block.forEachInVolume(center, radius, height, radius, pos -> {
                int dz;
                int dx = pos.method_10263() - center.method_10263();
                return dx * dx + (dz = pos.method_10260() - center.method_10260()) * dz <= radiusSq;
            }, action);
        }

        public static void forEachDiamond(class_2338 center, int radius, int height, Consumer<class_2338> action) {
            if (radius <= 0 || height <= 0) {
                return;
            }
            class_2338.class_2339 mutablePos = new class_2338.class_2339();
            for (int y = 0; y <= height; ++y) {
                int currentRadius = radius * (height - y) / height;
                for (int x = -currentRadius; x <= currentRadius; ++x) {
                    for (int z = -currentRadius; z <= currentRadius; ++z) {
                        if (Math.abs(x) + Math.abs(z) > currentRadius) continue;
                        mutablePos.method_10103(center.method_10263() + x, center.method_10264() + y, center.method_10260() + z);
                        action.accept((class_2338)mutablePos);
                        if (y == 0) continue;
                        mutablePos.method_33098(center.method_10264() - y);
                        action.accept((class_2338)mutablePos);
                    }
                }
            }
        }

        public static void forEachNeighbor(class_2338 pos, Consumer<class_2338> action) {
            class_2338.class_2339 mutablePos = new class_2338.class_2339();
            for (class_2350 dir : class_2350.values()) {
                action.accept((class_2338)mutablePos.method_25505((class_2382)pos, dir));
            }
        }

        public static ToIntFunction<class_2680> lightLit(int value, int baseValue) {
            return state -> (Boolean)state.method_11654((class_2769)class_2741.field_12548) != false ? value : baseValue;
        }

        public static boolean isFluid(class_2680 state) {
            return state.method_26227().method_15771();
        }

        private static void forEachInVolume(class_2338 center, int xRad, int yRad, int zRad, Predicate<class_2338> filter, Consumer<class_2338> action) {
            class_2338.class_2339 mutablePos = new class_2338.class_2339();
            for (int x = -xRad; x <= xRad; ++x) {
                for (int y = -yRad; y <= yRad; ++y) {
                    for (int z = -zRad; z <= zRad; ++z) {
                        mutablePos.method_10103(center.method_10263() + x, center.method_10264() + y, center.method_10260() + z);
                        if (!filter.test((class_2338)mutablePos)) continue;
                        action.accept((class_2338)mutablePos);
                    }
                }
            }
        }

        public static boolean isFullVoxel(class_2680 state, boolean inHeight) {
            class_265 shape = state.method_26220(null, null);
            return inHeight ? shape.method_1107().field_1322 == 0.0 && shape.method_1107().field_1325 == 1.0 : shape.method_1107().field_1323 == 0.0 && shape.method_1107().field_1320 == 1.0 && shape.method_1107().field_1322 == 0.0 && shape.method_1107().field_1325 == 1.0 && shape.method_1107().field_1321 == 0.0 && shape.method_1107().field_1324 == 1.0;
        }

        public static void updateBlockEntity(class_2586 be) {
            if (be.method_10997() == null) {
                return;
            }
            be.method_5431();
            be.method_10997().method_8413(be.method_11016(), be.method_11010(), be.method_11010(), 3);
        }
    }
}

