/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.builders;

import com.mw.nullcore.Utils;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class GuiRenderBuilder {
    public static final class_2960 BLOCK_ATLAS = class_2960.method_12829((String)"textures/atlas/blocks.png");
    protected final class_4597 mBuffer = Utils.Render.mBuffer;
    protected float u0;
    protected float v0;
    protected float u1;
    protected float v1;
    protected float a = 1.0f;
    protected float[] color;
    protected class_4588 vertex;
    protected class_4587 ps;
    protected class_4587.class_4665 pose;
    protected class_2960 texture;
    protected class_1058 sprite;

    public static GuiRenderBuilder builder() {
        return new GuiRenderBuilder();
    }

    public GuiRenderBuilder renderType(Function<class_2960, class_1921> type, class_2960 texture) {
        this.vertex = this.mBuffer.getBuffer(type.apply(texture));
        this.texture = texture;
        return this;
    }

    public GuiRenderBuilder renderType(class_2960 texture) {
        return this.renderType(class_1921::method_62277, texture);
    }

    public GuiRenderBuilder pose(class_4587 ps) {
        this.ps = ps;
        this.pose = ps.method_23760();
        return this;
    }

    public GuiRenderBuilder rotate(float angel) {
        this.ps.method_22907(new Quaternionf().rotateZ(angel));
        return this;
    }

    public GuiRenderBuilder spinner(float mSpeed) {
        float rotationTime = Utils.Render.getAnimationTick() * mSpeed + 0.5f;
        return this.rotate(rotationTime);
    }

    public GuiRenderBuilder scale(float scale) {
        this.ps.method_22905(scale, scale, 0.5f);
        return this;
    }

    public GuiRenderBuilder pulseScale(float min, float max, float mSpeed) {
        float pulse = class_3532.method_15374((float)(Utils.Render.getAnimationTick() * mSpeed)) * 0.5f + 0.5f;
        float scale = min + (min - max) * pulse;
        return this.scale(scale);
    }

    public GuiRenderBuilder moveBefore(float x, float y) {
        this.ps.method_46416(x, y, 100.0f);
        return this;
    }

    public GuiRenderBuilder moveAfter(float x, float y) {
        this.ps.method_46416(x, y, 159.0f);
        return this;
    }

    public GuiRenderBuilder color(int color) {
        this.color = Utils.Color.unpack(color, false);
        return this;
    }

    public GuiRenderBuilder color(float r, float g, float b) {
        this.color = new float[]{r, g, b, this.a};
        return this;
    }

    public GuiRenderBuilder color(float speed, int ... color) {
        this.color = Utils.Color.unpack(Utils.Color.getCyclingColor(speed, color), false);
        return this;
    }

    public GuiRenderBuilder alpha(float a) {
        this.a = a;
        return this;
    }

    public GuiRenderBuilder pulseAlpha(float mSpeed) {
        float pulse = class_3532.method_15374((float)(Utils.Render.getAnimationTick() * mSpeed)) * 0.5f + 0.5f;
        return this.alpha(pulse);
    }

    public GuiRenderBuilder buildOverlay(float size) {
        return this.buildOverlay(size, size);
    }

    public GuiRenderBuilder buildOverlay(float width, float height) {
        Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
        return this.renderQuad(positions, width, height);
    }

    private GuiRenderBuilder renderQuad(Vector3f[] positions, float width, float height) {
        if (this.vertex == null || this.ps == null) {
            return this;
        }
        for (Vector3f position : positions) {
            position.mul(width, height, width);
        }
        this.addVertex(positions[0], this.u0, this.v1);
        this.addVertex(positions[1], this.u1, this.v1);
        this.addVertex(positions[2], this.u1, this.v0);
        this.addVertex(positions[3], this.u0, this.v0);
        return this;
    }

    private void addVertex(Vector3f pos, float u, float v) {
        this.vertex.method_56824(this.pose, pos.x(), pos.y(), pos.z()).method_22915(this.color[0], this.color[1], this.color[2], this.a).method_22913(u, v);
    }
}

