/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mw.nullcore.NullCore;
import com.mw.nullcore.client.audio.TrackerController;
import com.mw.nullcore.core.blocks.type.ContainerBlockEntity;
import com.mw.nullcore.core.builders.ArmorMaterialBuilder;
import com.mw.nullcore.platform.Platform;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class Utils {
    @NotNull
    public static final Minecraft mc = Minecraft.getInstance();
    public static final RandomSource rand = RandomSource.create((long)1L);
    @NotNull
    public static final Font font = Utils.mc.font;
    public static final float partialTick = mc.getDeltaTracker().getGameTimeDeltaPartialTick(false);
    public static int clientTick;

    public static boolean isClient() {
        return Platform.PLATFORM.isClient();
    }

    public static final class Reader {
        public static Object parseJsonValue(JsonElement element, Object defaultValue) {
            if (defaultValue instanceof Boolean) {
                return element.getAsBoolean();
            }
            if (defaultValue instanceof Integer) {
                return element.getAsInt();
            }
            if (defaultValue instanceof Byte) {
                return element.getAsByte();
            }
            if (defaultValue instanceof Short) {
                return element.getAsShort();
            }
            if (defaultValue instanceof Long) {
                return element.getAsLong();
            }
            if (defaultValue instanceof Float) {
                return Float.valueOf(element.getAsFloat());
            }
            if (defaultValue instanceof String) {
                return element.getAsString();
            }
            if (defaultValue instanceof Character) {
                return Character.valueOf(element.getAsCharacter());
            }
            return null;
        }

        public static void addValueToJson(JsonObject json, String key, Object value) {
            if (value instanceof Boolean) {
                json.addProperty(key, (Boolean)value);
            } else if (value instanceof Number) {
                json.addProperty(key, (Number)value);
            } else if (value instanceof String) {
                json.addProperty(key, (String)value);
            } else if (value instanceof Character) {
                json.addProperty(key, (Character)value);
            }
        }
    }

    public static final class Level {
        public static void setBiome(ServerLevel level, ResourceKey<Biome> biome, BlockPos from, BlockPos to) {
            FillBiomeCommand.fill((ServerLevel)level, (BlockPos)from, (BlockPos)to, Level.getBiome((net.minecraft.world.level.Level)level, biome));
        }

        public static void setBiome(ServerLevel level, ResourceKey<Biome> biome, BlockPos pos) {
            Level.setBiome(level, biome, pos, pos);
        }

        public static Holder<Biome> getBiome(net.minecraft.world.level.Level level, ResourceKey<Biome> biome) {
            return level.registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(biome);
        }

        public static ResourceLocation getBiome(net.minecraft.world.level.Level level, Biome biome) {
            return level.registryAccess().lookupOrThrow(Registries.BIOME).getKey((Object)biome);
        }

        public static List<ResourceLocation> getStructuresAt(ServerLevel level, BlockPos pos) {
            Registry structureRegistry = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            return level.structureManager().getAllStructuresAt(pos).keySet().stream().map(arg_0 -> ((Registry)structureRegistry).getKey(arg_0)).filter(Objects::nonNull).toList();
        }

        public static boolean isStructure(net.minecraft.world.level.Level level, BlockPos pos, ResourceLocation structureId) {
            if (!(level instanceof ServerLevel)) {
                return false;
            }
            ServerLevel sl = (ServerLevel)level;
            Registry registry = sl.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            Structure structure = (Structure)registry.getValue(structureId);
            if (structure == null) {
                return false;
            }
            return sl.structureManager().getStructureAt(pos, structure).isValid();
        }

        public static List<Entity> getEntities(net.minecraft.world.level.Level level, BlockPos startPos, double radius) {
            return level.getEntities(null, new AABB((double)startPos.getX() - radius, (double)startPos.getY() - radius, (double)startPos.getZ() - radius, (double)startPos.getX() + radius, (double)startPos.getY() + radius, (double)startPos.getZ() + radius));
        }
    }

    public static final class Text {
        public static void addTooltipWithKey(int button, int colorButton, List<Component> adder, Component ... components) {
            if (InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)button)) {
                for (Component cm : components) {
                    if (cm == null) continue;
                    adder.add(cm);
                }
            } else {
                adder.add((Component)Component.translatable((String)"tooltip.nullcore.info", (Object[])new Object[]{Component.translatable((String)InputConstants.getKey((int)button, (int)0).toString()).withColor(colorButton)}));
            }
        }

        public static String formatNum(float amount) {
            float scaledNumber;
            String[] sufx = new String[]{"", "K", "M", "B", "T", "Qa", "Qt", "Sx", "Sp", "Oc", "N", "D"};
            int suffixIndex = 0;
            for (scaledNumber = amount; scaledNumber >= 1000.0f && suffixIndex < sufx.length - 1; scaledNumber /= 1000.0f, ++suffixIndex) {
            }
            DecimalFormat df = new DecimalFormat("#.#");
            return df.format(scaledNumber) + sufx[suffixIndex];
        }

        public static Component addLinerTextGradient(Object text, float speed, boolean toRight, int ... colors) {
            String string;
            if (text instanceof Component) {
                Component c = (Component)text;
                string = c.getString();
            } else {
                string = text.toString();
            }
            String str = string;
            RandomSource rand = RandomSource.create((long)1L);
            float offset = (toRight ? -(Render.getAnimationTick() * rand.nextFloat() + 0.5f) : Render.getAnimationTick() * rand.nextFloat() + 0.5f) * speed;
            MutableComponent component = Component.empty();
            int length = str.length();
            if (length == 0 || colors.length == 0) {
                return component;
            }
            if ((offset %= 1.0f) < 0.0f) {
                offset += 1.0f;
            }
            for (int i = 0; i < length; ++i) {
                float pos = (float)i / (float)length + offset;
                float colorPos = (pos %= 1.0f) * (float)(colors.length - 1);
                int colorIndex = (int)colorPos;
                float lerp = colorPos - (float)colorIndex;
                int color1 = colors[colorIndex % colors.length];
                int color2 = colors[(colorIndex + 1) % colors.length];
                int color = Color.lerpColors(lerp, color1, color2);
                component.append((Component)Component.literal((String)String.valueOf(str.charAt(i))).withStyle(style -> style.withColor(color)));
            }
            return component;
        }

        public static Component addTextGradient(Object text, float speed, int ... colors) {
            String string;
            if (text instanceof Component) {
                Component c = (Component)text;
                string = c.getString();
            } else {
                string = text.toString();
            }
            String str = string;
            int color = Color.getCyclingColor(speed, colors);
            return Component.literal((String)str).withColor(TextColor.fromRgb((int)(color & 0xFFFFFF)).getValue());
        }

        public static void addPositionTooltip(List<Component> tooltip, BlockPos pos, Component key, int colorPos, int colorData) {
            if (pos != null) {
                tooltip.add((Component)key.copy().withColor(colorPos));
                tooltip.add((Component)Component.literal((String)String.format("X: %d, Y: %d, Z: %d", pos.getX(), pos.getY(), pos.getZ())).withColor(colorData));
            }
        }

        public static void addTooltipEffects(List<Component> tooltip, MutableComponent component, List<ArmorMaterialBuilder.ShyEffect> list) {
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    MobEffect effect = (MobEffect)list.get(i).effect().value();
                    String effectName = effect.getDisplayName().getString();
                    component.append((Component)Component.literal((String)effectName).withColor(effect.getColor()));
                    if (i >= list.size() - 1) continue;
                    component.append((Component)Component.literal((String)", ").withStyle(component.getStyle()));
                }
                tooltip.add((Component)component);
            }
        }
    }

    public static final class Render {
        public static final MultiBufferSource mBuffer = mc.renderBuffers().bufferSource();

        public static void drawTexture(GuiGraphics gg, ResourceLocation texture, int x, int y, int u, int v, int pixelWidth, int pixelHeight, int width, int height, int color) {
            gg.blit(RenderType::guiTextured, texture, x, y, (float)u, (float)v, pixelWidth, pixelHeight, width, height, color);
        }

        public static void drawTexture(GuiGraphics gg, ResourceLocation texture, int x, int y, int u, int v, int pixelWidth, int pixelHeight, int width, int height) {
            Render.drawTexture(gg, texture, x, y, u, v, pixelWidth, pixelHeight, width, height, -1);
        }

        public static void drawLine(PoseStack ps, VertexConsumer buffer, float x1, float y1, float z1, float x2, float y2, float z2, int color, float width) {
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth((float)width);
            PoseStack.Pose pose = ps.last();
            buffer.addVertex(pose.pose(), x1, y1, z1).setColor(color);
            buffer.addVertex(pose.pose(), x2, y2, z2).setColor(color);
            RenderSystem.disableBlend();
        }

        public static void drawText(GuiGraphics gg, Object text, int x, int y, int color, boolean shadow) {
            String string;
            if (text instanceof Component) {
                Component c = (Component)text;
                string = c.getString();
            } else {
                string = text.toString();
            }
            String str = string;
            gg.drawString(font, str, x, y, color, shadow);
        }

        public static void drawText(GuiGraphics gg, Object text, int x, int y, int color) {
            Render.drawText(gg, text, x, y, color, false);
        }

        public static void renderRays(PoseStack ps, VertexConsumer buffer, int color, float time, float pTick) {
            ps.pushPose();
            RandomSource rand = RandomSource.create((long)1L);
            float rotationTime = (((float)clientTick + pTick) * rand.nextFloat() + 0.5f) * time;
            float[] rgb = Color.unpack(color, false);
            int count = rand.nextInt(10, 25);
            Vector3f center = new Vector3f(0.0f, 0.0f, 0.0f);
            for (int l = 0; l < count; ++l) {
                float length = rand.nextFloat();
                float width = rand.nextFloat() * 0.3f;
                Vector3f left = new Vector3f(-0.866f * width, length, -0.5f * width);
                Vector3f right = new Vector3f(0.866f * width, length, -0.5f * width);
                Vector3f front = new Vector3f(0.0f, length, width);
                Quaternionf rotate = new Quaternionf().rotationXYZ(rand.nextFloat() * ((float)Math.PI * 2) + rotationTime * 0.05f, (float)Math.PI * 2 + rotationTime * 0.08f, rand.nextFloat() * ((float)Math.PI * 2)).rotateXYZ(rand.nextFloat() * ((float)Math.PI * 2), rand.nextFloat() * ((float)Math.PI * 2), rand.nextFloat() * ((float)Math.PI * 2) + rotationTime * 0.06f);
                ps.mulPose(rotate);
                PoseStack.Pose pose = ps.last();
                buffer.addVertex(pose, center).setColor(1.0f, rgb[1] - 0.2f, rgb[2] - 0.2f, 1.0f);
                buffer.addVertex(pose, left).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.addVertex(pose, right).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.addVertex(pose, center).setColor(1.0f, rgb[1] - 0.2f, rgb[2] - 0.2f, 1.0f);
                buffer.addVertex(pose, right).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.addVertex(pose, front).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.addVertex(pose, center).setColor(1.0f, rgb[1] - 0.2f, rgb[2] - 0.2f, 1.0f);
                buffer.addVertex(pose, front).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                buffer.addVertex(pose, left).setColor(rgb[0], rgb[1], rgb[2], 0.0f);
                ps.mulPose(rotate.invert());
            }
            ps.popPose();
        }

        public static float getAnimationTick(float pTick) {
            return pTick + (float)clientTick;
        }

        public static float getAnimationTick() {
            return Render.getAnimationTick(partialTick);
        }

        public static TextureAtlasSprite getSprite(ResourceLocation texture) {
            TextureAtlas atlas = Minecraft.getInstance().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS);
            return atlas.getSprite(texture);
        }
    }

    public static final class Particle {
        public static void forParticleSpawn(net.minecraft.world.level.Level level, ParticleOptions particle, float pX, float pY, float pZ, float xSpeed, float ySpeed, float zSpeed, int count) {
            RandomSource rand = level.random;
            for (int i = 0; i < count; ++i) {
                double oX = (rand.nextDouble() - 0.5) * 0.5;
                double oY = (rand.nextDouble() - 0.5) * 0.5;
                double oZ = (rand.nextDouble() - 0.5) * 0.5;
                level.addParticle(particle, (double)pX + oX, (double)pY + oY, (double)pZ + oZ, (double)xSpeed, (double)ySpeed, (double)zSpeed);
            }
        }

        public static void forParticleSpawn(net.minecraft.world.level.Level level, ParticleOptions particle, float pX, float pY, float pZ, int count) {
            Particle.forParticleSpawn(level, particle, pX, pY, pZ, 0.0f, 0.0f, 0.0f, count);
        }

        public static void writeParticle(CompoundTag tag, ParticleOptions particle) {
            CompoundTag pTag = new CompoundTag();
            ResourceLocation loc = BuiltInRegistries.PARTICLE_TYPE.getKey((Object)particle.getType());
            pTag.putString("namespace", loc.getNamespace());
            pTag.putString("path", loc.getPath());
            tag.put("particle", (Tag)pTag);
        }

        public static ParticleOptions readParticle(CompoundTag tag) {
            CompoundTag pTag = (CompoundTag)tag.get("particle");
            return (ParticleOptions)BuiltInRegistries.PARTICLE_TYPE.getOptional(ResourceLocation.fromNamespaceAndPath((String)pTag.getString("namespace"), (String)pTag.getString("path"))).get();
        }
    }

    public static final class Mth {
        public static boolean chance(float chance) {
            return rand.nextFloat() < net.minecraft.util.Mth.clamp((float)chance, (float)0.0f, (float)1.0f);
        }

        public static String formatRealTime(long gameTime) {
            long totalSeconds = gameTime / 20L;
            long hours = totalSeconds / 3600L;
            long minutes = totalSeconds % 3600L / 60L;
            long seconds = totalSeconds % 60L;
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        }

        public static float perlinNoise(float x, float y, float z, float frequency, float amplitude) {
            float noise = 0.0f;
            for (int i = 0; i < 3; ++i) {
                noise += (float)(Math.sin(x * frequency) * Math.cos(y * frequency) * (z != 0.0f ? Math.sin(z * frequency) : 1.0) * (double)amplitude);
                frequency *= 2.0f;
                amplitude *= 0.4f;
            }
            return noise;
        }

        public static int secondTick(int seconds) {
            return seconds * 20;
        }

        public static int minuteTick(int minutes) {
            return Mth.secondTick(minutes * 60);
        }

        public static int hourTick(int hours) {
            return Mth.minuteTick(hours * 60);
        }

        public static int dayTick(int days) {
            return Mth.hourTick(days * 24);
        }

        public static float calculateProgress(float current, float max, float minOutput, float maxOutput) {
            if (max <= 0.0f) {
                return minOutput;
            }
            float progress = current / max;
            progress = net.minecraft.util.Mth.clamp((float)progress, (float)0.0f, (float)1.0f);
            return net.minecraft.util.Mth.lerp((float)progress, (float)minOutput, (float)maxOutput);
        }
    }

    public static final class Color {
        public static float[] unpack(int color, boolean asARGB) {
            float[] fArray;
            if (asARGB) {
                float[] fArray2 = new float[4];
                fArray2[0] = (float)(color >> 16 & 0xFF) / 255.0f;
                fArray2[1] = (float)(color >> 8 & 0xFF) / 255.0f;
                fArray2[2] = (float)(color & 0xFF) / 255.0f;
                fArray = fArray2;
                fArray2[3] = (float)(color >> 24 & 0xFF) / 255.0f;
            } else {
                float[] fArray3 = new float[4];
                fArray3[0] = (float)(color >> 24 & 0xFF) / 255.0f;
                fArray3[1] = (float)(color >> 16 & 0xFF) / 255.0f;
                fArray3[2] = (float)(color >> 8 & 0xFF) / 255.0f;
                fArray = fArray3;
                fArray3[3] = (float)(color & 0xFF) / 255.0f;
            }
            return fArray;
        }

        public static int pack(float r, float g, float b, float a, boolean asARGB) {
            return asARGB ? (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f) : (int)(r * 255.0f) << 24 | (int)(g * 255.0f) << 16 | (int)(b * 255.0f) << 8 | (int)(a * 255.0f);
        }

        public static int hexPack(String hexColor) {
            if (((String)hexColor).startsWith("#")) {
                hexColor = ((String)hexColor).substring(1);
            }
            if (((String)hexColor).length() == 6) {
                hexColor = "FF" + (String)hexColor;
            }
            return (int)Long.parseLong((String)hexColor, 16);
        }

        public static int lerpColors(float progress, int ... colors) {
            float segment = progress * (float)(colors.length - 1);
            int index = (int)segment;
            float factor = segment - (float)index;
            if (index >= colors.length - 1) {
                index = colors.length - 2;
                factor = 1.0f;
            }
            float[] c1 = Color.unpack(colors[index], false);
            float[] c2 = Color.unpack(colors[index + 1], false);
            return Color.pack(net.minecraft.util.Mth.lerp((float)factor, (float)c1[0], (float)c2[0]), net.minecraft.util.Mth.lerp((float)factor, (float)c1[1], (float)c2[1]), net.minecraft.util.Mth.lerp((float)factor, (float)c1[2], (float)c2[2]), net.minecraft.util.Mth.lerp((float)factor, (float)c1[3], (float)c2[3]), false);
        }

        public static int getCyclingColor(float speed, int ... colors) {
            float time = Render.getAnimationTick() * speed;
            return Color.lerpColors((net.minecraft.util.Mth.sin((float)time) + 1.0f) / 2.0f, colors);
        }

        public static int getRainbow(float speed) {
            int[] rainbow = new int[36];
            for (int i = 0; i < rainbow.length; ++i) {
                rainbow[i] = java.awt.Color.HSBtoRGB((float)i / 36.0f, 1.0f, 1.0f) & 0xFFFFFF;
            }
            return Color.getCyclingColor(speed, rainbow);
        }
    }

    public static final class Client {
        public static void setSafeScreen(Screen screen) {
            try {
                if (!mc.isSameThread()) {
                    mc.execute(() -> Client.setSafeScreen(screen));
                    return;
                }
                if (Utils.mc.level == null || Utils.mc.player == null) {
                    return;
                }
                if (!Utils.mc.level.isClientSide()) {
                    return;
                }
                mc.setScreen(screen);
            }
            catch (Exception e) {
                NullCore.LOG.error("Error launching {}, {}", (Object)screen.getClass().getName(), (Object)e.getMessage());
            }
        }

        public static void tickClient() {
            if (!mc.isPaused()) {
                TrackerController.tick();
                ++clientTick;
            }
        }

        public static boolean checkAdvancement(ServerPlayer player, ResourceLocation id) {
            AdvancementHolder advancement = player.server.getAdvancements().get(id);
            return advancement != null && player.getAdvancements().getOrStartProgress(advancement).isDone();
        }

        public static void sendMessage(Player player, Component key) {
            if (key != null) {
                player.displayClientMessage(key, true);
            }
        }
    }

    public static final class Item {
        public static NonNullList<ItemStack> inventoryToList(Container inv) {
            NonNullList list = NonNullList.withSize((int)inv.getContainerSize(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                list.set(i, (Object)inv.getItem(i).copy());
            }
            return list;
        }

        public static boolean insertItem(ContainerBlockEntity be, Player player, int slot, int maxTransfer) {
            SimpleContainer inv = be.getInventory();
            ItemStack slotStack = inv.getItem(slot);
            ItemStack heldStack = player.getMainHandItem();
            int actualMax = Math.min(maxTransfer, be.maxInSlot);
            if (heldStack.isEmpty()) {
                if (slotStack.isEmpty()) {
                    return false;
                }
                int transferAmount = Math.min(slotStack.getCount(), actualMax);
                player.setItemInHand(InteractionHand.MAIN_HAND, slotStack.copy());
                slotStack.shrink(transferAmount);
                inv.setItem(slot, slotStack.isEmpty() ? ItemStack.EMPTY : slotStack);
                return true;
            }
            if (slotStack.isEmpty()) {
                int transferAmount = Math.min(heldStack.getCount(), actualMax);
                ItemStack insert = heldStack.copyWithCount(transferAmount);
                inv.setItem(slot, insert);
                heldStack.shrink(transferAmount);
                return true;
            }
            if (ItemStack.isSameItem((ItemStack)slotStack, (ItemStack)heldStack)) {
                int spaceAvailable = Math.min(be.maxInSlot, slotStack.getMaxStackSize()) - slotStack.getCount();
                int transferAmount = Math.min(Math.min(heldStack.getCount(), spaceAvailable), actualMax);
                if (transferAmount <= 0) {
                    return false;
                }
                slotStack.grow(transferAmount);
                heldStack.shrink(transferAmount);
                inv.setItem(slot, slotStack);
                return true;
            }
            inv.setItem(slot, heldStack.copy());
            player.setItemInHand(InteractionHand.MAIN_HAND, slotStack.copy());
            return true;
        }

        public static LootTable getLootTable(ServerLevel level, ResourceKey<LootTable> id) {
            return level.getServer().reloadableRegistries().getLootTable(id);
        }

        public static LootParams getGiftParams(ServerLevel level, Vec3 pos, Entity entity, float luck) {
            return new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)pos).withLuck(luck).create(LootContextParamSets.GIFT);
        }

        public static List<ItemStack> createLoot(ResourceKey<LootTable> id, LootParams params) {
            LootTable loot = Item.getLootTable(params.getLevel(), id);
            if (loot == LootTable.EMPTY) {
                return Lists.newArrayList();
            }
            return loot.getRandomItems(params);
        }

        public static void giveLoot(Player player, List<ItemStack> items) {
            for (ItemStack stack : items) {
                if (player.getInventory().add(stack)) continue;
                player.drop(stack, false);
            }
        }

        public static void spawnLoot(net.minecraft.world.level.Level level, BlockPos pPos, Collection<ItemStack> items) {
            if (!level.isClientSide()) {
                for (ItemStack stack : items) {
                    level.addFreshEntity((Entity)new ItemEntity(level, (double)((float)pPos.getX() + 0.5f), (double)((float)pPos.getY() + 0.5f), (double)((float)pPos.getZ() + 0.5f), stack));
                }
            }
        }

        public static <T> void instanceOf(net.minecraft.world.item.Item item, Class<T> targetClass, Consumer<T> action) {
            net.minecraft.world.item.Item target;
            if (item instanceof BlockItem) {
                BlockItem bi = (BlockItem)item;
                v0 = bi.getBlock();
            } else {
                v0 = target = item;
            }
            if (targetClass.isInstance(target)) {
                action.accept(targetClass.cast(target));
            }
        }
    }

    public static final class Block {
        public static void forEachCube(BlockPos center, int radius, Consumer<BlockPos> action) {
            Block.forEachInVolume(center, radius, radius, radius, pos -> true, action);
        }

        public static void forEachSphere(BlockPos center, int radius, Consumer<BlockPos> action) {
            int radiusSq = radius * radius;
            Block.forEachInVolume(center, radius, radius, radius, pos -> {
                int dz;
                int dy;
                int dx = pos.getX() - center.getX();
                return dx * dx + (dy = pos.getY() - center.getY()) * dy + (dz = pos.getZ() - center.getZ()) * dz <= radiusSq;
            }, action);
        }

        public static void forEachCircle(BlockPos center, int radius, int height, Consumer<BlockPos> action) {
            int radiusSq = radius * radius;
            Block.forEachInVolume(center, radius, height, radius, pos -> {
                int dz;
                int dx = pos.getX() - center.getX();
                return dx * dx + (dz = pos.getZ() - center.getZ()) * dz <= radiusSq;
            }, action);
        }

        public static void forEachDiamond(BlockPos center, int radius, int height, Consumer<BlockPos> action) {
            if (radius <= 0 || height <= 0) {
                return;
            }
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int y = 0; y <= height; ++y) {
                int currentRadius = radius * (height - y) / height;
                for (int x = -currentRadius; x <= currentRadius; ++x) {
                    for (int z = -currentRadius; z <= currentRadius; ++z) {
                        if (Math.abs(x) + Math.abs(z) > currentRadius) continue;
                        mutablePos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                        action.accept((BlockPos)mutablePos);
                        if (y == 0) continue;
                        mutablePos.setY(center.getY() - y);
                        action.accept((BlockPos)mutablePos);
                    }
                }
            }
        }

        public static void forEachNeighbor(BlockPos pos, Consumer<BlockPos> action) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (Direction dir : Direction.values()) {
                action.accept((BlockPos)mutablePos.setWithOffset((Vec3i)pos, dir));
            }
        }

        public static ToIntFunction<BlockState> lightLit(int value, int baseValue) {
            return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? value : baseValue;
        }

        public static boolean isFluid(BlockState state) {
            return state.getFluidState().isSource();
        }

        private static void forEachInVolume(BlockPos center, int xRad, int yRad, int zRad, Predicate<BlockPos> filter, Consumer<BlockPos> action) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int x = -xRad; x <= xRad; ++x) {
                for (int y = -yRad; y <= yRad; ++y) {
                    for (int z = -zRad; z <= zRad; ++z) {
                        mutablePos.set(center.getX() + x, center.getY() + y, center.getZ() + z);
                        if (!filter.test((BlockPos)mutablePos)) continue;
                        action.accept((BlockPos)mutablePos);
                    }
                }
            }
        }

        public static boolean isFullVoxel(BlockState state, boolean inHeight) {
            VoxelShape shape = state.getCollisionShape(null, null);
            return inHeight ? shape.bounds().minY == 0.0 && shape.bounds().maxY == 1.0 : shape.bounds().minX == 0.0 && shape.bounds().maxX == 1.0 && shape.bounds().minY == 0.0 && shape.bounds().maxY == 1.0 && shape.bounds().minZ == 0.0 && shape.bounds().maxZ == 1.0;
        }

        public static void updateBlockEntity(BlockEntity be) {
            if (be.getLevel() == null) {
                return;
            }
            be.setChanged();
            be.getLevel().sendBlockUpdated(be.getBlockPos(), be.getBlockState(), be.getBlockState(), 3);
        }
    }
}

