/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import com.mw.nullcore.client.particle.screen.ParticleEmitterHandler;
import com.mw.nullcore.core.NcConfig;
import com.mw.nullcore.core.NcUtils;
import com.mw.nullcore.core.builders.CommandBuilder;
import com.mw.nullcore.core.items.CreativeContent;
import com.mw.nullcore.core.items.Renderable;
import com.mw.nullcore.registers.NcComponents;
import com.mw.nullcore.registers.NcEntities;
import com.mw.nullcore.registers.NcEvents;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import org.slf4j.Logger;

@Mod(value="nullcore")
public final class NullCore {
    public static final String ID = "nullcore";
    public static final Logger LOGGER = LogUtils.getLogger();

    public NullCore(IEventBus bus) {
        IEventBus game = NeoForge.EVENT_BUS;
        NcComponents.components.register(bus);
        NcEntities.entities.register(bus);
        NcConfig.init();
        game.addListener(event -> CommandBuilder.registerAll((CommandDispatcher<CommandSourceStack>)event.getDispatcher()));
        bus.addListener(event -> {
            for (Item item : BuiltInRegistries.ITEM) {
                NcUtils.Item.instanceOf(item, CreativeContent.class, cc -> {
                    if (event.getTabKey() == cc.getCreativeTab()) {
                        cc.addContents((CreativeModeTab.Output)event);
                    }
                });
            }
        });
        game.addListener(NcEvents::onResourceReload);
        bus.addListener(this::client);
    }

    public void client(FMLClientSetupEvent event) {
        for (Item item : BuiltInRegistries.ITEM) {
            if (!(item instanceof Renderable)) continue;
            Renderable supplier = (Renderable)item;
            ParticleEmitterHandler.registerEmitters(item, supplier);
        }
    }

    public static ResourceLocation path(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public static <T> ResourceKey<T> key(ResourceKey<? extends Registry<T>> key, String id) {
        return ResourceKey.create(key, (ResourceLocation)NullCore.path(id));
    }

    public static <T> ResourceKey<T> key(ResourceKey<? extends Registry<T>> key, String modid, String id) {
        return ResourceKey.create(key, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)modid, (String)id));
    }
}

