/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.particle.data;

import com.mw.nullcore.client.particle.screen.GenericScreenParticle;
import net.minecraft.client.particle.SpriteSet;

public class SpriteParticleData {
    public static final SpriteParticleData RANDOM = new Random();
    public static final SpriteParticleData FIRST = new First();
    public static final SpriteParticleData LAST = new Last();
    public static final SpriteParticleData WITH_AGE = new WithAge();
    public static final SpriteParticleData CRUMBS_RANDOM = new CrumbsRandom(3.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_FIRST = new CrumbsFirst(3.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_LAST = new CrumbsLast(3.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_WITH_AGE = new CrumbsWithAge(3.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_LARGE_RANDOM = new CrumbsRandom(1.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_LARGE_FIRST = new CrumbsFirst(1.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_LARGE_LAST = new CrumbsLast(1.0f, 1.0f);
    public static final SpriteParticleData CRUMBS_LARGE_WITH_AGE = new CrumbsWithAge(1.0f, 1.0f);

    public void init(GenericScreenParticle particle) {
    }

    public void tick(GenericScreenParticle particle) {
    }

    public void renderTick(GenericScreenParticle particle, float partialTicks) {
    }

    public float getU0(GenericScreenParticle particle) {
        return particle.sprite.getU0();
    }

    public float getU1(GenericScreenParticle particle) {
        return particle.sprite.getU1();
    }

    public float getV0(GenericScreenParticle particle) {
        return particle.sprite.getV0();
    }

    public float getV1(GenericScreenParticle particle) {
        return particle.sprite.getV1();
    }

    public static class Random
    extends SpriteParticleData {
        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite((SpriteSet)particle.spriteSet);
            }
        }
    }

    public static class First
    extends SpriteParticleData {
        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }
    }

    public static class Last
    extends SpriteParticleData {
        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.spriteSet.sprites.size() - 1);
            }
        }
    }

    public static class WithAge
    extends SpriteParticleData {
        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }

        @Override
        public void tick(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.age * particle.spriteSet.sprites.size() / particle.lifetime);
            }
        }
    }

    public static class CrumbsRandom
    extends Crumbs {
        public CrumbsRandom(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite((SpriteSet)particle.spriteSet);
            }
        }
    }

    public static class CrumbsFirst
    extends Crumbs {
        public CrumbsFirst(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }
    }

    public static class CrumbsLast
    extends Crumbs {
        public CrumbsLast(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.spriteSet.sprites.size() - 1);
            }
        }
    }

    public static class CrumbsWithAge
    extends Crumbs {
        public CrumbsWithAge(float offset, float size) {
            super(offset, size);
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(0);
            }
        }

        @Override
        public void tick(GenericScreenParticle particle) {
            if (particle.spriteSet != null) {
                particle.pickSprite(particle.age * particle.spriteSet.sprites.size() / particle.lifetime);
            }
        }
    }

    public static class CrumbsValue
    extends Crumbs {
        public int value;

        public CrumbsValue(int value, float offset, float size) {
            super(offset, size);
            this.value = value;
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null && this.value >= 0 && this.value < particle.spriteSet.sprites.size()) {
                particle.pickSprite(this.value);
            }
        }
    }

    public static class Crumbs
    extends SpriteParticleData {
        public float offset;
        public float size;

        public Crumbs(float offset, float size) {
            this.offset = offset;
            this.size = size;
        }

        @Override
        public float getU0(GenericScreenParticle particle) {
            return particle.sprite.getU0() + (particle.sprite.getU1() - particle.sprite.getU0()) * ((particle.uo * this.offset + this.size) / (this.offset + this.size));
        }

        @Override
        public float getU1(GenericScreenParticle particle) {
            return particle.sprite.getU0() + (particle.sprite.getU1() - particle.sprite.getU0()) * (particle.uo * this.offset / (this.offset + this.size));
        }

        @Override
        public float getV0(GenericScreenParticle particle) {
            return particle.sprite.getV0() + (particle.sprite.getV1() - particle.sprite.getV0()) * (particle.vo * this.offset / (this.offset + this.size));
        }

        @Override
        public float getV1(GenericScreenParticle particle) {
            return particle.sprite.getV0() + (particle.sprite.getV1() - particle.sprite.getV0()) * ((particle.vo * this.offset + this.size) / (this.offset + this.size));
        }
    }

    public static class Value
    extends SpriteParticleData {
        public int value;

        public Value(int value) {
            this.value = value;
        }

        @Override
        public void init(GenericScreenParticle particle) {
            if (particle.spriteSet != null && this.value >= 0 && this.value < particle.spriteSet.sprites.size()) {
                particle.pickSprite(this.value);
            }
        }
    }
}

