/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mw.nullcore.client.render.NcShaders;
import com.mw.nullcore.core.NcUtils;
import net.minecraft.client.renderer.ShaderProgram;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public interface NcRenderType {
    public static final NcRenderType ADDITIVE = new NcRenderType(){

        @Override
        public BufferBuilder begin(Tesselator tesselator, TextureManager manager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)1);
            RenderSystem.setShader((ShaderProgram)NcShaders.SCREENPARTICLE);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        }

        @Override
        public void end(BufferBuilder builder) {
            MeshData meshdata = builder.build();
            if (meshdata != null) {
                BufferUploader.drawWithShader((MeshData)meshdata);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }
    };
    public static final NcRenderType TRANSPARENT = new NcRenderType(){

        @Override
        public BufferBuilder begin(Tesselator tesselator, TextureManager manager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            RenderSystem.setShader((ShaderProgram)NcShaders.SCREENPARTICLE);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        }

        @Override
        public void end(BufferBuilder builder) {
            MeshData meshdata = builder.build();
            if (meshdata != null) {
                BufferUploader.drawWithShader((MeshData)meshdata);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }
    };
    public static final NcRenderType LUMITRANSPARENT = new NcRenderType(){

        @Override
        public BufferBuilder begin(Tesselator tesselator, TextureManager manager) {
            RenderSystem.depthMask((boolean)false);
            RenderSystem.enableBlend();
            ShaderProgram shader = NcShaders.SCREENPARTICLE;
            RenderSystem.setShader((ShaderProgram)shader);
            NcUtils.mc.getShaderManager().getProgram(shader).safeGetUniform("LumiTransparency").set(1.0f);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_PARTICLES);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            return tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
        }

        @Override
        public void end(BufferBuilder builder) {
            MeshData meshdata = builder.build();
            if (meshdata != null) {
                BufferUploader.drawWithShader((MeshData)meshdata);
            }
            RenderSystem.depthMask((boolean)true);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            NcUtils.mc.getShaderManager().getProgram(NcShaders.SCREENPARTICLE).safeGetUniform("LumiTransparency").set(0.0f);
        }
    };

    public BufferBuilder begin(Tesselator var1, TextureManager var2);

    public void end(BufferBuilder var1);
}

