/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;

public abstract class ShyScreen
extends Screen {
    PoseStack ps;
    protected float ticks;
    final int[] animIDs;
    public final int bgWidth;
    public final int bgHeight;

    protected ShyScreen(int bgWidth, int bgHeight, int ... animIDs) {
        super((Component)Component.empty());
        this.bgWidth = bgWidth;
        this.bgHeight = bgHeight;
        this.animIDs = animIDs;
    }

    public void render(GuiGraphics gg, int mouseX, int mouseY, float pTick) {
        this.markGG(gg);
        this.renderBackground(gg, mouseX, mouseY, pTick);
        if (this.animIDs != null) {
            this.autoPose(() -> {
                block5: for (int id : this.animIDs) {
                    switch (id) {
                        case 0: {
                            this.move(0.0f, 200.0f - this.ticks * 200.0f);
                            continue block5;
                        }
                        case 1: {
                            this.rotate(this.guiXCenter(), this.guiYCenter(), new Quaternionf().rotateZ(this.ticks * ((float)Math.PI * 2)));
                            continue block5;
                        }
                        case 2: {
                            this.scale(this.guiXCenter(), this.guiYCenter(), this.ticks, this.ticks, this.ticks);
                        }
                    }
                }
                this.draw(gg, mouseX, mouseY, pTick);
            });
        } else {
            this.draw(gg, mouseX, mouseY, pTick);
        }
    }

    public void tick() {
        this.ticks = (float)Mth.clamp((double)((double)this.ticks + 0.03 * (1.0 + 10.0 * (double)this.ticks)), (double)0.0, (double)1.0);
    }

    protected void draw(GuiGraphics gg, int mouseX, int mouseY, float pTick) {
        for (Renderable renderable : this.renderables) {
            renderable.render(gg, mouseX, mouseY, pTick);
        }
    }

    public Minecraft mc() {
        return Minecraft.getInstance();
    }

    public void markGG(GuiGraphics gg) {
        if (gg != null) {
            this.ps = gg.pose();
        }
    }

    public PoseStack ps() {
        return this.ps;
    }

    public void start() {
        this.ps.pushPose();
    }

    public void stop() {
        this.ps.popPose();
    }

    public void autoPose(Runnable action) {
        this.start();
        action.run();
        this.stop();
    }

    public void rotate(float pX, float pY, Quaternionf angel) {
        this.move(pX, pY);
        this.ps.mulPose(angel);
        this.move(-pX, -pY);
    }

    public void scale(float pX, float pY, float sX, float sY, float sZ) {
        this.move(pX, pY);
        this.ps.scale(sX, sY, sZ);
        this.move(-pX, -pY);
    }

    public void scale(float pX, float pY, float sX, float sY) {
        this.scale(pX, pY, sX, sY, 0.0f);
    }

    public void move(float pX, float pY, float pZ) {
        this.ps.translate(pX, pY, pZ);
    }

    public void move(float pX, float pY) {
        this.move(pX, pY, 0.0f);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public int guiLeft() {
        return (this.width - this.bgWidth) / 2;
    }

    public int guiTop() {
        return (this.height - this.bgHeight) / 2;
    }

    public int guiXCenter() {
        return this.width / 2;
    }

    public int guiYCenter() {
        return this.height / 2;
    }
}

