/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.builders;

import com.mw.nullcore.core.NcUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.world.phys.Vec3;

public final class CameraShakeBuilder {
    public static final List<CameraShakeBuilder> shakes = new ArrayList<CameraShakeBuilder>();
    float frequency;
    float amplitude;
    float distance;
    float maxDistance;
    int time;

    public static CameraShakeBuilder builder() {
        return new CameraShakeBuilder();
    }

    public CameraShakeBuilder shake(int time, float frequency, float amplitude, float distance, float maxDistance) {
        this.time = time;
        this.frequency = frequency;
        this.amplitude = amplitude;
        this.distance = distance;
        this.maxDistance = maxDistance;
        shakes.add(this);
        return this;
    }

    public CameraShakeBuilder shake(int time, float frequency, float amplitude, float distance) {
        return this.shake(time, frequency, amplitude, distance, 25.0f);
    }

    public CameraShakeBuilder shake(int time, float frequency, float amplitude) {
        return this.shake(time, frequency, amplitude, 0.0f, 0.0f);
    }

    public CameraShakeBuilder shake(int time, float frequency, float amplitude, Vec3 from, Vec3 to, float maxDistance) {
        return this.shake(time, frequency, amplitude, (float)from.distanceTo(to), maxDistance);
    }

    public static void tick(Camera cam) {
        if (!shakes.isEmpty()) {
            for (CameraShakeBuilder shake2 : shakes) {
                if (shake2.time < 0) continue;
                float dis = 1.0f - Math.min(1.0f, shake2.distance != 0.0f && shake2.maxDistance != 0.0f ? shake2.distance / shake2.maxDistance : 0.0f);
                float progress = (float)shake2.time / 20.0f * dis;
                float intensity = shake2.amplitude * progress * progress;
                float frequency = shake2.frequency * (0.5f + progress * 0.5f);
                float time = NcUtils.Render.getAnimationTick() * frequency * 0.2f;
                float offsetX = CameraShakeBuilder.calculateNoise(time, 0.0f, 0.0f, frequency) * intensity * 0.6f;
                float offsetY = CameraShakeBuilder.calculateNoise(0.0f, time, 0.0f, frequency) * intensity;
                float offsetZ = CameraShakeBuilder.calculateNoise(0.0f, 0.0f, time, frequency) * intensity * 0.6f;
                Vec3 vec = cam.getPosition();
                cam.setPosition(vec.x() + (double)offsetX, vec.y() + (double)offsetY, vec.z() + (double)offsetZ);
                --shake2.time;
            }
            shakes.removeIf(shake -> shake.time <= 0);
        }
    }

    public static float calculateNoise(float x, float y, float z, float frequency) {
        return (float)(Math.sin(x * frequency * 1.0f) * (double)0.4f + Math.cos(y * frequency * 1.7f) * (double)0.3f + Math.sin(z * frequency * 2.3f + 1.5f) * (double)0.2f + Math.cos(x * frequency * 3.1f + y * 2.7f) * (double)0.1f);
    }
}

