/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.mixin;

import com.google.common.collect.Multimap;
import com.mw.nullcore.client.audio.ClientTracker;
import com.mw.nullcore.client.audio.Fading;
import com.mw.nullcore.client.audio.TrackerTicker;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.sounds.SoundSource;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SoundEngine.class})
public abstract class SoundEngineMixin
implements Fading {
    @Shadow
    @Final
    private Multimap<SoundSource, SoundInstance> instanceBySource;
    @Unique
    private boolean nc$fading;
    @Unique
    private int nc$tick;
    @Unique
    private SoundInstance nc$sound;

    @Shadow
    public abstract void setVolume(SoundInstance var1, float var2);

    @Shadow
    public abstract void stop(SoundInstance var1);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void nc$onTick(CallbackInfo ci) {
        if (this.nc$fading) {
            if (this.nc$sound != null) {
                if (this.nc$tick > 0) {
                    --this.nc$tick;
                    this.setVolume(this.nc$sound, Math.max(0.0f, (float)this.nc$tick / 45.0f));
                } else {
                    this.stop(this.nc$sound);
                    this.setFade(false);
                }
            } else {
                this.setFade(false);
            }
        }
    }

    @Override
    @Unique
    public void setFade(boolean fading) {
        this.instanceBySource.get((Object)SoundSource.MUSIC).stream().findFirst().ifPresent(s -> {
            if (!(s instanceof TrackerTicker.TrackAmbient)) {
                this.nc$sound = s;
            }
        });
        this.nc$tick = 45;
        this.nc$fading = fading;
    }

    @Inject(method={"play"}, at={@At(value="HEAD")}, cancellable=true)
    private void nc$play(SoundInstance sound, CallbackInfo ci) {
        if (ClientTracker.shouldCancelSound(sound)) {
            ci.cancel();
        }
    }
}

