/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.audio;

import com.mw.nullcore.Utils;
import com.mw.nullcore.client.NullConfig;
import com.mw.nullcore.client.audio.Fading;
import com.mw.nullcore.client.audio.Track;
import com.mw.nullcore.core.managers.TracksManager;
import com.mw.nullcore.core.mixin.SoundManagerAccessor;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public final class TrackerTicker {
    @NotNull
    final Minecraft mc = Minecraft.getInstance();
    private TrackAmbient track;
    private Track selectedTrack;
    private int timeNextTrack = 300;
    public ResourceLocation currentStage;

    public void tick() {
        if (this.mc.player == null || this.mc.level == null) {
            return;
        }
        ResourceLocation id = this.getStage((Level)this.mc.level, this.mc.player.blockPosition());
        if (this.selectedTrack == null || this.timeNextTrack == 0) {
            this.selectedTrack = null;
            HashSet<Track> tracks = TracksManager.selfTracks.get(id);
            if (tracks != null) {
                this.selectedTrack = this.getTrack(tracks, (Level)this.mc.level);
            }
        }
        if (id != this.currentStage) {
            this.stop(this.mc.level.random);
        }
        this.currentStage = id;
        if (this.canPlay()) {
            this.play(this.selectedTrack, this.mc.level.random);
        }
    }

    private ResourceLocation getStage(Level level, BlockPos pos) {
        for (Entity entity : Utils.Level.getEntities(level, pos, NullConfig.radiusEntityTrack.get().byteValue())) {
            ResourceLocation entityId = EntityType.getKey((EntityType)entity.getType());
            if (!TracksManager.selfTracks.containsKey(entityId)) continue;
            return entityId;
        }
        for (ResourceLocation structureId : TracksManager.selfTracks.keySet()) {
            ServerLevel sl;
            if (!(level instanceof ServerLevel) || !Utils.Level.isPosInStructure((Level)(sl = (ServerLevel)level), pos, structureId)) continue;
            return structureId;
        }
        return level.dimension().location();
    }

    private boolean canPlay() {
        if (this.selectedTrack == null) {
            return false;
        }
        if (this.track != null && this.mc.getSoundManager().isActive((SoundInstance)this.track)) {
            return false;
        }
        if (this.timeNextTrack > 0) {
            --this.timeNextTrack;
            return false;
        }
        return true;
    }

    private Track getTrack(HashSet<Track> trackList, Level level) {
        List tl = trackList.stream().toList();
        return trackList.size() > 1 ? (Track)tl.get(level.random.nextInt(trackList.size())) : (Track)tl.get(0);
    }

    public void play(Track track, RandomSource rand) {
        ((Fading)((SoundManagerAccessor)this.mc.getSoundManager()).getSoundEngine()).setFade(true);
        this.track = new TrackAmbient(track.getSound(), SoundSource.MUSIC);
        this.track.setTick(45);
        this.mc.getSoundManager().play((SoundInstance)this.track);
        this.timeNextTrack = Mth.nextInt((RandomSource)rand, (int)track.minDelay(), (int)track.maxDelay());
    }

    public void stop(RandomSource rand) {
        if (this.track != null) {
            this.track.fade = true;
            this.track = null;
            this.timeNextTrack = Mth.nextInt((RandomSource)rand, (int)100, (int)300);
        }
    }

    public boolean playingTrack() {
        return this.track != null;
    }

    public boolean isMusic(SoundInstance sound) {
        return this.track == sound;
    }

    public static class TrackAmbient
    extends AbstractTickableSoundInstance {
        private int tick;
        public boolean fade;

        protected TrackAmbient(SoundEvent sound, SoundSource source) {
            super(sound, source, SoundInstance.createUnseededRandom());
        }

        public void tick() {
            if (this.tick >= 0) {
                this.tick = !this.fade ? ++this.tick : --this.tick;
                this.setTick(Math.min(this.tick, 45));
                this.setVolume(Math.max(0.0f, Math.min((float)this.tick / 45.0f, 1.0f)));
            } else {
                this.stop();
            }
        }

        public void setVolume(float volume) {
            this.volume = volume;
        }

        public void setTick(int tick) {
            this.tick = tick;
        }
    }
}

