/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.builders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mw.nullcore.Utils;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class GuiRenderBuilder {
    static final Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
    static float pTick = Utils.partialTick;
    private VertexConsumer vertex;
    private PoseStack ps;
    float u0;
    float v0;
    float u1;
    float v1;
    float alpha = 1.0f;
    float lifeTime;
    float[] color;
    int countPer;

    private GuiRenderBuilder() {
    }

    public static GuiRenderBuilder builder() {
        return new GuiRenderBuilder();
    }

    public GuiRenderBuilder copyData(GuiRenderBuilder builder) {
        builder.ps = this.ps;
        this.vertex = builder.vertex;
        this.u0 = builder.u0;
        this.u1 = builder.u1;
        this.v0 = builder.v0;
        this.v1 = builder.v1;
        this.alpha = builder.alpha;
        this.color = builder.color;
        return this;
    }

    @NotNull
    public GuiRenderBuilder renderType(Function<ResourceLocation, RenderType> type, String modId, String path) {
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)modId, (String)path);
        MultiBufferSource.BufferSource mBuffer = Utils.mc.renderBuffers().bufferSource();
        this.vertex = mBuffer.getBuffer(type.apply(texture));
        return this;
    }

    public GuiRenderBuilder color(float mSpeed, int ... color) {
        this.color = Utils.Color.unpack(Utils.Color.lerpColors(mSpeed, color), false);
        return this;
    }

    public GuiRenderBuilder color(int color) {
        return this.color(0.0f, color);
    }

    public GuiRenderBuilder alpha(float alpha) {
        this.alpha = alpha;
        return this;
    }

    public GuiRenderBuilder pulseAlpha(float mSpeed) {
        float pulse = Mth.sin((float)(((float)Utils.clientTick + pTick) * mSpeed)) * 0.5f + 0.5f;
        return this.alpha(pulse);
    }

    public GuiRenderBuilder poseStack(PoseStack ps) {
        this.ps = ps;
        return this;
    }

    public GuiRenderBuilder rotate(float angel) {
        this.ps.mulPose(new Quaternionf().rotateZ(angel));
        return this;
    }

    public GuiRenderBuilder spinner(float mSpeed) {
        float rotationTime = ((float)Utils.clientTick + pTick) * mSpeed + 0.5f;
        return this.rotate(rotationTime);
    }

    public GuiRenderBuilder scale(float scale) {
        this.ps.scale(scale, scale, 0.5f);
        return this;
    }

    public GuiRenderBuilder pulseScale(float min, float max, float mSpeed) {
        float pulse = Mth.sin((float)(((float)Utils.clientTick + pTick) * mSpeed)) * 0.5f + 0.5f;
        float scale = min + (min - max) * pulse;
        return this.scale(scale);
    }

    public GuiRenderBuilder move(float x, float y) {
        return this.move(x, y, 100.0f);
    }

    public GuiRenderBuilder move(float x, float y, float z) {
        this.ps.translate(x, y, z);
        return this;
    }

    public GuiRenderBuilder buildOverlay(float size) {
        return this.addFrame(size);
    }

    private GuiRenderBuilder lifeSettings(float lifeTime, int countPer) {
        this.lifeTime = lifeTime;
        this.countPer = countPer;
        return this;
    }

    private GuiRenderBuilder buildParticle(float size, float pTick) {
        return this;
    }

    private GuiRenderBuilder addFrame(float size) {
        this.u0 = size;
        this.v0 = size;
        this.u1 = size - 1.0f;
        this.v1 = size - 1.0f;
        for (Vector3f position : positions) {
            position.mul(size, size, size);
        }
        this.addVertex(positions[0], this.u0, this.v1);
        this.addVertex(positions[1], this.u1, this.v1);
        this.addVertex(positions[2], this.u1, this.v0);
        this.addVertex(positions[3], this.u0, this.v0);
        return this;
    }

    private void addVertex(Vector3f pos, float u, float v) {
        if (this.ps == null || this.vertex == null) {
            return;
        }
        this.vertex.addVertex(this.ps.last(), pos.x(), pos.y(), pos.z()).setColor(this.color[0], this.color[1], this.color[2], this.alpha).setUv(u, v);
    }
}

