/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.managers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mw.nullcore.NullCore;
import com.mw.nullcore.Utils;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class LockableManager
extends SimplePreparableReloadListener<Map<ResourceLocation, LockableEntry>> {
    public static final Map<ResourceLocation, LockableEntry> selfLockable = new HashMap<ResourceLocation, LockableEntry>();

    public Map<ResourceLocation, LockableEntry> prepare(ResourceManager manager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, LockableEntry> lockable = new HashMap<ResourceLocation, LockableEntry>();
        Map resources = manager.listResources("level", id -> id.getPath().endsWith("lockable.json"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                InputStream stream = ((Resource)entry.getValue()).open();
                try {
                    String jsonContent = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    Map<ResourceLocation, LockableEntry> parsedData = LockableManager.parseLockable(jsonContent);
                    lockable.putAll(parsedData);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                NullCore.LOG.error("Failed to load lockable from {}: {}", entry.getKey(), (Object)e.getMessage());
            }
        }
        return lockable;
    }

    public void apply(Map<ResourceLocation, LockableEntry> allLockable, ResourceManager manager, ProfilerFiller profiler) {
        selfLockable.clear();
        selfLockable.putAll(allLockable);
    }

    public static Map<ResourceLocation, LockableEntry> parseLockable(String json) {
        HashMap<ResourceLocation, LockableEntry> lockable = new HashMap<ResourceLocation, LockableEntry>();
        try {
            JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
            for (Map.Entry entry : root.entrySet()) {
                ResourceLocation id = ResourceLocation.tryParse((String)((String)entry.getKey()));
                if (id == null) {
                    NullCore.LOG.warn("Invalid resource ID: {}", entry.getKey());
                    continue;
                }
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                JsonObject entryObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                LockableEntry lockableEntry = LockableManager.parseLockableEntry(entryObj);
                lockable.put(id, lockableEntry);
            }
        }
        catch (JsonParseException e) {
            NullCore.LOG.error("Failed to parse lockable JSON: {}", (Object)e.getMessage());
        }
        return lockable;
    }

    private static LockableEntry parseLockableEntry(JsonObject json) {
        ResourceLocation soundId;
        boolean lock = false;
        if (json.has("lock")) {
            JsonObject requiredObj = json.getAsJsonObject("lock");
            lock = requiredObj.getAsBoolean();
        }
        RequiredCondition required = null;
        if (json.has("required")) {
            JsonObject requiredObj = json.getAsJsonObject("required");
            ResourceLocation advancement = requiredObj.has("advancement") ? ResourceLocation.tryParse((String)requiredObj.get("advancement").getAsString()) : null;
            required = new RequiredCondition(advancement);
        }
        MutableComponent message = null;
        if (json.has("message")) {
            JsonElement messageElem = json.get("message");
            if (messageElem.isJsonObject()) {
                JsonObject ms = messageElem.getAsJsonObject();
                String text = ms.get("text").getAsString();
                message = Component.translatable((String)text);
                if (ms.has("color")) {
                    JsonElement color = ms.get("color");
                    message = message.copy().withColor(color.getAsJsonPrimitive().isNumber() ? color.getAsInt() : Utils.Color.hexPack(color.getAsString()));
                }
            } else {
                message = Component.translatable((String)messageElem.getAsString());
            }
        }
        SoundEvent soundMessage = null;
        if (json.has("sound_message") && (soundId = ResourceLocation.tryParse((String)json.get("sound_message").getAsString())) != null) {
            soundMessage = (SoundEvent)BuiltInRegistries.SOUND_EVENT.getValue(soundId);
        }
        ArrayList<Item> ignoreItems = new ArrayList<Item>();
        if (json.has("ignore")) {
            JsonArray ignoreArray = json.getAsJsonArray("ignore");
            for (JsonElement element : ignoreArray) {
                ResourceLocation itemId = ResourceLocation.tryParse((String)element.getAsString());
                if (itemId == null) continue;
                Item item = (Item)BuiltInRegistries.ITEM.getValue(itemId);
                ignoreItems.add(item);
            }
        }
        return new LockableEntry(lock, required, (Component)message, soundMessage, ignoreItems);
    }

    public static boolean canBlocked(ServerPlayer player, InteractionHand hand, BlockPos pos, ServerLevel level) {
        for (ResourceLocation id : selfLockable.keySet()) {
            if (!Utils.Level.isPosInStructure((Level)level, pos, id) && !level.getBiome(pos).is(id)) continue;
            LockableEntry entry = selfLockable.get(id);
            ItemStack itemInHand = player.getItemInHand(hand);
            if (!entry.lock()) {
                RequiredCondition required = entry.required();
                if (required == null) {
                    return false;
                }
                if (!Utils.Client.checkAdvancement(player, required.advancement())) {
                    if (entry.ignoreItems() == null || entry.ignoreItems().contains(itemInHand.getItem())) continue;
                    LockableManager.sendLockMessage((Player)player, entry, (Level)level);
                    return true;
                }
                return false;
            }
            if (entry.ignoreItems() != null && entry.ignoreItems().contains(itemInHand.getItem())) {
                return false;
            }
            LockableManager.sendLockMessage((Player)player, entry, (Level)level);
            return true;
        }
        return false;
    }

    private static void sendLockMessage(Player player, LockableEntry entry, Level level) {
        Utils.Text.sendMessage(player, entry.message());
        if (entry.soundMessage() != null) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), entry.soundMessage(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public record LockableEntry(boolean lock, RequiredCondition required, Component message, SoundEvent soundMessage, List<Item> ignoreItems) {
    }

    public record RequiredCondition(ResourceLocation advancement) {
    }
}

