/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.mixin;

import com.mw.nullcore.core.managers.BiomeRulesManager;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public final class MobMixin {
    @Inject(method={"isSunBurnTick"}, at={@At(value="HEAD")}, cancellable=true)
    private void nc$isSunBurnTick(CallbackInfoReturnable<Boolean> cir) {
        Mob mob = (Mob)this;
        Level level = mob.level();
        Holder biome = level.getBiome(mob.blockPosition());
        ResourceLocation id = biome.unwrapKey().map(ResourceKey::location).orElse(null);
        Optional<Boolean> time = BiomeRulesManager.getRules(id).flatMap(r -> r.getRule("fixed_time", Long.class));
        Optional<Boolean> weather = BiomeRulesManager.getRules(id).flatMap(r -> r.getRule("rain_force", Float.class));
        if (time.isPresent() || weather.isPresent()) {
            boolean isDay = time.map(t -> t % 24000L < 12000L).orElseGet(() -> level.getDayTime() % 24000L < 12000L);
            boolean isRaining = weather.map(intensity -> intensity.floatValue() > 0.5f).orElseGet(() -> level.isRainingAt(mob.blockPosition()));
            cir.setReturnValue((Object)(isDay && !isRaining ? 1 : 0));
        }
    }
}

