/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.platform;

import java.util.ServiceLoader;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;

public interface Platform {
    public static final Platform PLATFORM = Platform.load(Platform.class);

    public static <T> T load(Class<T> clazz) {
        return ServiceLoader.load(clazz).findFirst().orElseThrow(() -> new NullPointerException("Failed to load service for " + clazz.getName()));
    }

    public boolean isClient();

    public String getPlatformName();

    public boolean isModLoaded(String var1);

    public boolean isDevelopmentEnvironment();

    default public String getEnvironmentName() {
        return this.isDevelopmentEnvironment() ? "development" : "production";
    }

    public <T> Supplier<T> register(Registry<? super T> var1, String var2, Supplier<T> var3);

    public void sendTo(Player var1, CustomPacketPayload var2);
}

