/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.builders;

import com.mw.nullcore.NullCore;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_10394;
import net.minecraft.class_1291;
import net.minecraft.class_1657;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_8051;

public final class ArmorMaterialBuilder {
    public static final Map<class_1741, ShyEffect[]> effects = new HashMap<class_1741, ShyEffect[]>();
    int durabilityMultiplier = 1;
    int[] protectionAmounts = new int[]{2, 5, 6, 2, 5};
    int enchantability = 10;
    private class_6880<class_3414> sound = class_3417.field_14862;
    float toughness;
    float knockbackResistance;
    private class_6862<class_1792> repair;
    private class_5321<class_10394> asset;
    private ShyEffect[] shyEffects;

    public static ArmorMaterialBuilder builder() {
        return new ArmorMaterialBuilder();
    }

    public ArmorMaterialBuilder durability(int multiplier) {
        this.durabilityMultiplier = multiplier;
        return this;
    }

    public ArmorMaterialBuilder protection(int boots, int leggings, int chestplate, int helmet, int fullSet) {
        this.protectionAmounts = new int[]{boots, leggings, chestplate, helmet, fullSet};
        return this;
    }

    public ArmorMaterialBuilder protection(int[] protectionArray) {
        this.protectionAmounts = protectionArray;
        return this;
    }

    public ArmorMaterialBuilder enchantability(int enchantability) {
        this.enchantability = enchantability;
        return this;
    }

    public ArmorMaterialBuilder sound(class_6880<class_3414> sound) {
        this.sound = sound;
        return this;
    }

    public ArmorMaterialBuilder toughness(float toughness) {
        this.toughness = toughness;
        return this;
    }

    public ArmorMaterialBuilder resistance(float resistance) {
        this.knockbackResistance = resistance;
        return this;
    }

    public ArmorMaterialBuilder repairTag(class_6862<class_1792> repair) {
        this.repair = repair;
        return this;
    }

    public ArmorMaterialBuilder asset(String modid, String id) {
        class_5321 equipmentAssets = class_5321.method_29180((class_2960)class_2960.method_60655((String)modid, (String)"equipment_asset"));
        this.asset = NullCore.key(equipmentAssets, modid, id);
        return this;
    }

    public ArmorMaterialBuilder asset(class_5321<class_10394> asset) {
        this.asset = asset;
        return this;
    }

    public ArmorMaterialBuilder effects(ShyEffect ... effects) {
        this.shyEffects = effects;
        return this;
    }

    public class_1741 build() {
        EnumMap<class_8051, Integer> defenseMap = new EnumMap<class_8051, Integer>(class_8051.class);
        defenseMap.put(class_8051.field_41937, this.protectionAmounts[0]);
        defenseMap.put(class_8051.field_41936, this.protectionAmounts[1]);
        defenseMap.put(class_8051.field_41935, this.protectionAmounts[2]);
        defenseMap.put(class_8051.field_41934, this.protectionAmounts[3]);
        defenseMap.put(class_8051.field_48838, this.protectionAmounts[4]);
        class_1741 material = new class_1741(this.durabilityMultiplier * 10, Map.copyOf(defenseMap), this.enchantability, this.sound, this.toughness, this.knockbackResistance, this.repair, this.asset);
        if (this.shyEffects != null) {
            effects.put(material, this.shyEffects);
        }
        return material;
    }

    public static ShyEffect of(class_6880<class_1291> effect, int time, int level, boolean visible, Predicate<class_1657> condition) {
        return new ShyEffect(effect, time, level, visible, condition);
    }

    public static ShyEffect of(class_6880<class_1291> effect, int time, int level, boolean visible) {
        return ArmorMaterialBuilder.of(effect, time, level, visible, p -> true);
    }

    public static ShyEffect of(class_6880<class_1291> effect, int time, int level) {
        return ArmorMaterialBuilder.of(effect, time, level, true);
    }

    public static ShyEffect of(class_6880<class_1291> effect, int time) {
        return ArmorMaterialBuilder.of(effect, time, 0);
    }

    public record ShyEffect(class_6880<class_1291> effect, int time, int level, boolean visible, Predicate<class_1657> condition) {
    }
}

