/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.builders;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;

public final class CommandBuilder {
    private static final List<Consumer<CommandDispatcher<CommandSourceStack>>> commands = new ArrayList<Consumer<CommandDispatcher<CommandSourceStack>>>();
    private final List<ArgumentBuilder<CommandSourceStack, ?>> children = new ArrayList();
    private final String id;
    private int permission = 2;
    private CommandExecutor executor;

    private CommandBuilder(String id) {
        this.id = id;
    }

    public static CommandBuilder builder(String id) {
        return new CommandBuilder(id);
    }

    public CommandBuilder requires(int permissionLevel) {
        this.permission = permissionLevel;
        return this;
    }

    public CommandBuilder executes(CommandExecutor executor) {
        this.executor = executor;
        return this;
    }

    public CommandBuilder then(ArgumentBuilder<CommandSourceStack, ?> argument) {
        this.children.add(argument);
        return this;
    }

    public CommandBuilder then(LiteralArgumentBuilder<CommandSourceStack> argument) {
        this.children.add((ArgumentBuilder<CommandSourceStack, ?>)argument);
        return this;
    }

    public void register() {
        commands.add(dispatcher -> {
            LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.literal((String)this.id).requires(src -> src.hasPermission(this.permission));
            if (this.executor != null) {
                builder.executes(this.executor::execute);
            }
            for (ArgumentBuilder<CommandSourceStack, ?> child : this.children) {
                builder.then(child);
            }
            dispatcher.register(builder);
        });
    }

    public static void registerAll(CommandDispatcher<CommandSourceStack> dispatcher) {
        for (Consumer<CommandDispatcher<CommandSourceStack>> command : commands) {
            command.accept(dispatcher);
        }
    }

    public static LiteralArgumentBuilder<CommandSourceStack> literal(String name) {
        return Commands.literal((String)name);
    }

    @FunctionalInterface
    public static interface CommandExecutor {
        public int execute(CommandContext<CommandSourceStack> var1);
    }
}

