/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.entities;

import com.mw.nullcore.registers.NullEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class ShyBlockEntity
extends Entity {
    static final EntityDataAccessor<BlockState> block = SynchedEntityData.defineId(ShyBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.BLOCK_STATE);
    static final EntityDataAccessor<Integer> lifeTime = SynchedEntityData.defineId(ShyBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    static Type anim = Type.fall;

    public ShyBlockEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    public ShyBlockEntity(Level level, double pX, double pY, double pZ, BlockState state) {
        super(NullEntities.shyBlock.get(), level);
        this.setPos(pX, pY, pZ);
        this.setBlock(state);
    }

    public ShyBlockEntity(Level level, BlockPos pos, BlockState state) {
        this(level, (float)pos.getX() + 0.5f, pos.getY(), (float)pos.getZ() + 0.5f, state);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(block, (Object)Blocks.GRASS_BLOCK.defaultBlockState());
        builder.define(lifeTime, (Object)999);
    }

    public void tick() {
        int time = this.getLifeTime();
        if (time != 999 || this.getAnimType() == Type.fall) {
            this.setLifeTime(--time);
            if (time <= 0) {
                this.discard();
            }
        }
    }

    public boolean hurtServer(ServerLevel level, DamageSource damage, float pTick) {
        return false;
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        this.setBlock(NbtUtils.readBlockState((HolderGetter)this.level().holderLookup(Registries.BLOCK), (CompoundTag)tag));
        this.setLifeTime(tag.getInt("life_time"));
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.put("block", (Tag)NbtUtils.writeBlockState((BlockState)this.getBlock()));
        tag.putInt("life_time", this.getLifeTime());
    }

    public ShyBlockEntity setBlock(BlockState state) {
        this.entityData.set(block, (Object)state);
        return this;
    }

    public BlockState getBlock() {
        return (BlockState)this.entityData.get(block);
    }

    public ShyBlockEntity setLifeTime(int time) {
        this.entityData.set(lifeTime, (Object)time);
        return this;
    }

    public int getLifeTime() {
        return (Integer)this.entityData.get(lifeTime);
    }

    public void spawn() {
        this.level().addFreshEntity((Entity)this);
    }

    public Type getAnimType() {
        return anim;
    }

    public ShyBlockEntity setAnimType(Type anim) {
        ShyBlockEntity.anim = anim;
        return this;
    }

    public static enum Type {
        fall(-10.0f),
        mixing(-0.2f),
        rebound(-10.0f);

        public final float yOffset;

        private Type(float yOffset) {
            this.yOffset = yOffset;
        }
    }
}

