/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.entities;

import com.mojang.datafixers.util.Pair;
import com.mw.nullcore.Utils;
import com.mw.nullcore.registers.NullEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ShyItemEntity
extends ItemEntity {
    static final EntityDataAccessor<Boolean> canRays = SynchedEntityData.defineId(ShyItemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final EntityDataAccessor<Boolean> canParticle = SynchedEntityData.defineId(ShyItemEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    static final EntityDataAccessor<Integer> color = SynchedEntityData.defineId(ShyItemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    static final EntityDataAccessor<Integer> countParticle = SynchedEntityData.defineId(ShyItemEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    static final EntityDataAccessor<ParticleOptions> particle = SynchedEntityData.defineId(ShyItemEntity.class, (EntityDataSerializer)EntityDataSerializers.PARTICLE);

    public ShyItemEntity(EntityType<ShyItemEntity> entityType, Level level) {
        super(entityType, level);
    }

    public ShyItemEntity(Level level, float pX, float pY, float pZ, ItemStack stack) {
        this(NullEntities.shyItem.get(), level);
        this.setPos(pX, pY, pZ);
        this.setItem(stack);
    }

    public ShyItemEntity(Level level, BlockPos pos, ItemStack stack, boolean upBlock) {
        this(level, (float)pos.getX() + 0.5f, (float)pos.getY() + (upBlock ? 1.5f : 0.5f), (float)pos.getZ() + 0.5f, stack);
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && ((Boolean)this.entityData.get(canParticle)).booleanValue() && this.tickCount % 15 == 0) {
            Utils.Particle.forParticleSpawn(this.level(), this.getParticle(), (float)this.getX(), (float)this.getY() + 0.3f, (float)this.getZ(), (Integer)this.entityData.get(countParticle));
        }
    }

    public ShyItemEntity setParticle(boolean enabled, ParticleOptions particle, int count) {
        this.entityData.set(canParticle, (Object)enabled);
        this.entityData.set(ShyItemEntity.particle, particle != null ? particle : ParticleTypes.EFFECT);
        this.entityData.set(countParticle, (Object)count);
        return this;
    }

    public ShyItemEntity setRays(boolean enabled, int color) {
        this.entityData.set(canRays, (Object)enabled);
        this.entityData.set(ShyItemEntity.color, (Object)color);
        return this;
    }

    public Pair<Boolean, Integer> getRays() {
        return Pair.of((Object)((Boolean)this.entityData.get(canRays)), (Object)((Integer)this.entityData.get(color)));
    }

    public ParticleOptions getParticle() {
        return (ParticleOptions)this.entityData.get(particle);
    }

    public void spawn() {
        this.level().addFreshEntity((Entity)this);
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(canRays, (Object)false);
        builder.define(color, (Object)0);
        builder.define(canParticle, (Object)false);
        builder.define(particle, (Object)ParticleTypes.EFFECT);
        builder.define(countParticle, (Object)0);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("canRays", ((Boolean)this.getRays().getFirst()).booleanValue());
        tag.putInt("color", ((Integer)this.getRays().getSecond()).intValue());
        tag.putBoolean("canParticle", ((Boolean)this.entityData.get(canParticle)).booleanValue());
        tag.putInt("countParticle", ((Integer)this.entityData.get(countParticle)).intValue());
        Utils.Particle.writeParticle(tag, this.getParticle());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setRays(tag.getBoolean("canRays"), tag.getInt("color"));
        this.setParticle(tag.getBoolean("canParticle"), Utils.Particle.readParticle(tag), tag.getInt("countParticle"));
    }
}

