/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.multiblocks;

import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface Blueprint {
    public Direction validateStructure(Level var1, BlockPos var2);

    public void onBuilt(Level var1, BlockPos var2, Structure var3);

    public Structure getStructure(Level var1, BlockPos var2);

    default public boolean canActivate(Player player, Level level, ItemStack stack) {
        return false;
    }

    public Blueprint condition(BiPredicate<Player, ItemStack> var1);

    default public void applyResult(Level level, BlockPos pos, Object result, Direction facing) {
        if (result instanceof Block) {
            Block block = (Block)result;
            BlockState state = block.defaultBlockState();
            if (facing != null && state.hasProperty((Property)HorizontalDirectionalBlock.FACING)) {
                state = (BlockState)state.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing);
            }
            level.setBlock(pos, state, 2);
        } else if (result instanceof Item) {
            Item item = (Item)result;
            this.applyItemResult(level, pos, item);
        }
    }

    default public void applyItemResult(Level level, BlockPos pos, Item item) {
        ItemEntity entity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, new ItemStack((ItemLike)item));
        entity.setNoGravity(true);
        entity.setDeltaMovement(0.0, 0.0, 0.0);
        if (this.setItemEntity() != null) {
            entity = this.setItemEntity();
        }
        level.addFreshEntity((Entity)entity);
    }

    default public ItemEntity setItemEntity() {
        return null;
    }

    default public Item getActivator() {
        return null;
    }

    public static class Rotation {
        int rows;
        int cols;
        Object[][] matrix;

        public Rotation(Object[][] matrix) {
            this.rows = matrix.length;
            this.cols = matrix[0].length;
            this.matrix = new Object[this.rows][this.cols];
            for (int i = 0; i < this.rows; ++i) {
                System.arraycopy(matrix[i], 0, this.matrix[i], 0, this.cols);
            }
        }

        public void rotateRight(int times) {
            for (int a = 0; a < times; ++a) {
                Object[][] newMatrix = new Object[this.cols][this.rows];
                for (int i = 0; i < this.rows; ++i) {
                    for (int j = 0; j < this.cols; ++j) {
                        newMatrix[j][this.rows - i - 1] = this.matrix[i][j];
                    }
                }
                this.matrix = newMatrix;
                int tmp = this.rows;
                this.rows = this.cols;
                this.cols = tmp;
            }
        }
    }

    public record Result(Object required, Object result) {
    }

    public record Structure(int xOffset, int yOffset, int zOffset, Direction facing) {
    }
}

