/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.audio;

import com.mw.nullcore.core.NcConfig;
import com.mw.nullcore.core.NcUtils;
import com.mw.nullcore.core.managers.TracksManager;
import com.mw.nullcore.core.network.StagerPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public final class ServerTracker {
    public static void tick(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new StagerPacket(ServerTracker.getStage((Level)player.serverLevel(), player.blockPosition())), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static ResourceLocation getStage(Level level, BlockPos pos) {
        for (Entity entity : NcUtils.Level.getEntities(level, pos, NcConfig.radiusEntityTrack.get().byteValue())) {
            ResourceLocation entityId = EntityType.getKey((EntityType)entity.getType());
            if (!TracksManager.selfTracks.containsKey(entityId)) continue;
            return entityId;
        }
        for (ResourceLocation structureId : TracksManager.selfTracks.keySet()) {
            ServerLevel sl;
            if (!(level instanceof ServerLevel) || !NcUtils.Level.isStructure((Level)(sl = (ServerLevel)level), pos, structureId)) continue;
            return structureId;
        }
        return level.dimension().location();
    }
}

