/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.particle.screen;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.math.Axis;
import com.mw.nullcore.client.particle.screen.ScreenParticle;
import com.mw.nullcore.core.NcUtils;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class QuadScreenParticle
extends ScreenParticle {
    protected float quadSize = 0.1f * (random.nextFloat() * 0.5f + 0.5f) * 2.0f;
    public TextureAtlasSprite sprite;

    protected QuadScreenParticle(ClientLevel pLevel, double pX, double pY) {
        super(pLevel, pX, pY);
    }

    protected QuadScreenParticle(ClientLevel pLevel, double pX, double pY, double pXSpeed, double pYSpeed) {
        super(pLevel, pX, pY, pXSpeed, pYSpeed);
    }

    @Override
    public void render(BufferBuilder bufferBuilder) {
        float partialTicks = NcUtils.partialTick;
        float size = this.getQuadSize(partialTicks) * 10.0f;
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        Vector3f[] vectors = this.getVector3fs(partialTicks, size);
        float quadZ = this.getQuadZPosition();
        bufferBuilder.addVertex(vectors[0].x(), vectors[0].y(), quadZ).setUv(u1, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
        bufferBuilder.addVertex(vectors[1].x(), vectors[1].y(), quadZ).setUv(u1, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
        bufferBuilder.addVertex(vectors[2].x(), vectors[2].y(), quadZ).setUv(u0, v0).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
        bufferBuilder.addVertex(vectors[3].x(), vectors[3].y(), quadZ).setUv(u0, v1).setColor(this.rCol, this.gCol, this.bCol, this.alpha);
    }

    private Vector3f @NotNull [] getVector3fs(float partialTicks, float size) {
        float roll = Mth.lerp((float)partialTicks, (float)this.oRoll, (float)this.roll);
        Vector3f[] vectors = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        Quaternionf rotation = new Quaternionf((Quaternionfc)Axis.ZN.rotationDegrees(roll));
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vectors[i];
            vector3f.rotate((Quaternionfc)rotation);
            vector3f.mul(size);
            vector3f.add((float)this.x, (float)this.y, 0.0f);
        }
        return vectors;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize;
    }

    public float getQuadZPosition() {
        return 390.0f;
    }

    protected void setSprite(TextureAtlasSprite pSprite) {
        this.sprite = pSprite;
    }

    protected float getU0() {
        return this.sprite.getU0();
    }

    protected float getU1() {
        return this.sprite.getU1();
    }

    protected float getV0() {
        return this.sprite.getV0();
    }

    protected float getV1() {
        return this.sprite.getV1();
    }

    public void pickSprite(SpriteSet pSprite) {
        this.setSprite(pSprite.get(random));
    }
}

