/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.blocks.type;

import com.mw.nullcore.core.NcUtils;
import com.mw.nullcore.core.blocks.type.ContainerHave;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class ContainerBlockEntity
extends BlockEntity
implements ContainerHave,
Container {
    public final SimpleContainer inventory;
    public final int maxInSlot;

    public ContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int slots, int maxInSlot) {
        super(type, pos, state);
        this.inventory = new SimpleContainer(slots){

            public void setChanged() {
                super.setChanged();
                ContainerBlockEntity.this.setChanged();
                NcUtils.Block.updateBlockEntity(ContainerBlockEntity.this);
            }
        };
        this.maxInSlot = maxInSlot;
    }

    public ContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int slots) {
        this(type, pos, state, slots, 1);
    }

    public ContainerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        this(type, pos, state, 1, 1);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        NonNullList items = NonNullList.withSize((int)this.inventory.getContainerSize(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)registries);
        for (int i = 0; i < items.size(); ++i) {
            this.inventory.setItem(i, (ItemStack)items.get(i));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        NonNullList items = NonNullList.withSize((int)this.inventory.getContainerSize(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < this.inventory.getContainerSize(); ++i) {
            items.set(i, (Object)this.inventory.getItem(i));
        }
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)registries);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public ItemStack getFirst() {
        return this.inventory.getItem(0);
    }

    @Override
    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public int getContainerSize() {
        return this.inventory.getContainerSize();
    }

    public boolean isEmpty() {
        return this.inventory.isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.inventory.getItem(slot);
    }

    public ItemStack removeItem(int slot, int amount) {
        ItemStack stack = this.inventory.removeItem(slot, amount);
        this.setChanged();
        return stack;
    }

    public ItemStack removeItemNoUpdate(int slot) {
        return this.inventory.removeItemNoUpdate(slot);
    }

    public void setItem(int slot, ItemStack stack) {
        this.inventory.setItem(slot, stack);
        this.setChanged();
    }

    public void setFirst(ItemStack stack) {
        this.setItem(0, stack);
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this, (Player)player);
    }

    public void clearContent() {
        this.inventory.clearContent();
        this.setChanged();
    }
}

