/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.builders;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mw.nullcore.core.NcUtils;
import java.util.function.Function;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class GuiRenderBuilder {
    private final MultiBufferSource mBuffer = NcUtils.Render.mBuffer;
    private float u0;
    private float v0;
    private float u1;
    private float v1;
    private float a = 1.0f;
    private float[] color;
    private VertexConsumer vertex;
    private PoseStack ps;
    private PoseStack.Pose pose;
    private ResourceLocation texture;

    public static GuiRenderBuilder builder() {
        return new GuiRenderBuilder();
    }

    public GuiRenderBuilder renderType(Function<ResourceLocation, RenderType> type, ResourceLocation texture) {
        this.vertex = this.mBuffer.getBuffer(type.apply(texture));
        this.texture = texture;
        return this;
    }

    public GuiRenderBuilder renderType(ResourceLocation texture) {
        return this.renderType(RenderType::guiTextured, texture);
    }

    public GuiRenderBuilder renderType(RenderType type) {
        this.vertex = this.mBuffer.getBuffer(type);
        return this;
    }

    public GuiRenderBuilder pose(PoseStack ps) {
        this.ps = ps;
        this.pose = ps.last();
        return this;
    }

    public GuiRenderBuilder rotate(float angel) {
        this.ps.mulPose(new Quaternionf().rotateZ(angel));
        return this;
    }

    public GuiRenderBuilder spinner(float mSpeed) {
        float rotationTime = NcUtils.Render.getAnimationTick() * mSpeed + 0.5f;
        return this.rotate(rotationTime);
    }

    public GuiRenderBuilder scale(float scale) {
        this.ps.scale(scale, scale, 0.5f);
        return this;
    }

    public GuiRenderBuilder move(float x, float y, float z) {
        this.ps.translate(x, y, z);
        return this;
    }

    public GuiRenderBuilder moveAfter(float x, float y) {
        this.ps.translate(x, y, 159.0f);
        return this;
    }

    public GuiRenderBuilder color(int color) {
        this.color = NcUtils.Color.unpack(color, false);
        return this;
    }

    public GuiRenderBuilder color(float r, float g, float b) {
        this.color = new float[]{r, g, b, this.a};
        return this;
    }

    public GuiRenderBuilder color(float speed, int ... color) {
        this.color = NcUtils.Color.unpack(NcUtils.Color.getCyclingColor(speed, color), false);
        return this;
    }

    public GuiRenderBuilder alpha(float a) {
        this.a = a;
        return this;
    }

    public GuiRenderBuilder pulseAlpha(float mSpeed) {
        float pulse = Mth.sin((float)(NcUtils.Render.getAnimationTick() * mSpeed)) * 0.5f + 0.5f;
        return this.alpha(pulse);
    }

    public GuiRenderBuilder buildOverlay(float size) {
        return this.buildOverlay(size, size);
    }

    public GuiRenderBuilder buildOverlay(float width, float height) {
        this.u0 = width;
        this.v0 = height;
        this.u1 = width - 1.0f;
        this.v1 = height - 1.0f;
        Vector3f[] positions = new Vector3f[]{new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f)};
        return this.renderQuad(positions, width, height);
    }

    private GuiRenderBuilder renderQuad(Vector3f[] positions, float width, float height) {
        for (Vector3f position : positions) {
            position.mul(width, height, width);
        }
        this.addVertex(positions[0], this.u0, this.v0);
        this.addVertex(positions[1], this.u1, this.v0);
        this.addVertex(positions[2], this.u1, this.v1);
        this.addVertex(positions[3], this.u0, this.v1);
        return this;
    }

    private void addVertex(Vector3f pos, float u, float v) {
        this.vertex.addVertex(this.pose, pos.x(), pos.y(), pos.z()).setColor(this.color[0], this.color[1], this.color[2], this.a).setUv(u, v);
    }
}

