/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.managers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mw.nullcore.NullCore;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public final class BiomeRulesManager
extends SimplePreparableReloadListener<Map<ResourceLocation, BiomeRules>> {
    private static final Map<String, RuleType<?>> ruleTypes = new HashMap();
    private static final Map<ResourceLocation, BiomeRules> biomeRules = new HashMap<ResourceLocation, BiomeRules>();

    public Map<ResourceLocation, BiomeRules> prepare(ResourceManager manager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, BiomeRules> rules = new HashMap<ResourceLocation, BiomeRules>();
        Map resources = manager.listResources("level", id -> id.getPath().endsWith("biome_rules.json"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                InputStream stream = ((Resource)entry.getValue()).open();
                try {
                    String json = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
                    for (Map.Entry biomeEntry : root.entrySet()) {
                        ResourceLocation biomeId = ResourceLocation.tryParse((String)((String)biomeEntry.getKey()));
                        BiomeRules biomeRule = BiomeRulesManager.parseBiomeRules(((JsonElement)biomeEntry.getValue()).getAsJsonObject());
                        if (biomeRule.isEmpty()) continue;
                        rules.put(biomeId, biomeRule);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                NullCore.LOGGER.info("Failed to load biome rules from {}: {}", entry.getKey(), (Object)e.getMessage());
            }
        }
        return rules;
    }

    public void apply(Map<ResourceLocation, BiomeRules> rules, ResourceManager manager, ProfilerFiller profiler) {
        biomeRules.clear();
        biomeRules.putAll(rules);
    }

    public static BiomeRules parseBiomeRules(JsonObject biomeJson) {
        BiomeRules rules = new BiomeRules();
        for (Map.Entry ruleEntry : biomeJson.entrySet()) {
            RuleType<?> type = ruleTypes.get(ruleEntry.getKey());
            if (type == null) {
                NullCore.LOGGER.warn("Unknown rule type: {}", ruleEntry.getKey());
                continue;
            }
            try {
                rules.addRule((String)ruleEntry.getKey(), type.parse((JsonElement)ruleEntry.getValue()));
            }
            catch (Exception e) {
                NullCore.LOGGER.warn("Invalid rule format for {}: {}", ruleEntry.getKey(), (Object)e.getMessage());
            }
        }
        return rules;
    }

    public static Optional<BiomeRules> getRules(ResourceLocation biomeId) {
        return Optional.ofNullable(biomeRules.get(biomeId));
    }

    public static <T> void registerRuleType(String key, Function<JsonElement, T> parser, Class<T> type) {
        ruleTypes.put(key, new RuleType<T>(parser, type));
    }

    static {
        BiomeRulesManager.registerRuleType("fixed_time", JsonElement::getAsLong, Long.class);
        BiomeRulesManager.registerRuleType("rain_force", JsonElement::getAsFloat, Float.class);
        BiomeRulesManager.registerRuleType("has_precipitation", JsonElement::getAsBoolean, Boolean.class);
    }

    public static class BiomeRules {
        private final Map<String, Object> rules = new HashMap<String, Object>();

        public <T> void addRule(String key, T value) {
            this.rules.put(key, value);
        }

        public <T> Optional<T> getRule(String key, Class<T> type) {
            Object value = this.rules.get(key);
            return type.isInstance(value) ? Optional.of(value) : Optional.empty();
        }

        public boolean isEmpty() {
            return this.rules.isEmpty();
        }
    }

    private record RuleType<T>(Function<JsonElement, T> parser, Class<T> type) {
        public T parse(JsonElement json) {
            return this.parser.apply(json);
        }
    }
}

