/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.managers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mw.nullcore.NullCore;
import com.mw.nullcore.client.audio.Track;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public final class TracksManager
extends SimplePreparableReloadListener<Map<ResourceLocation, HashSet<Track>>> {
    public static final Map<ResourceLocation, HashSet<Track>> selfTracks = new HashMap<ResourceLocation, HashSet<Track>>();

    public Map<ResourceLocation, HashSet<Track>> prepare(ResourceManager manager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, HashSet<Track>> allTracks = new HashMap<ResourceLocation, HashSet<Track>>();
        Map resources = manager.listResources("level", id -> id.getPath().endsWith("tracks.json"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                InputStream stream = ((Resource)entry.getValue()).open();
                try {
                    String jsonContent = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    Map<ResourceLocation, HashSet<Track>> parsedTracks = TracksManager.parseTracks(jsonContent);
                    parsedTracks.forEach((id, tracks) -> allTracks.merge((ResourceLocation)id, (HashSet<Track>)tracks, (oldTracks, newTracks) -> {
                        HashSet merged = new HashSet(oldTracks);
                        merged.addAll(newTracks);
                        return merged;
                    }));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                NullCore.LOGGER.info("Failed to load tracks from {}: {}", entry.getKey(), (Object)e.getMessage());
            }
        }
        return allTracks;
    }

    public void apply(@NotNull Map<ResourceLocation, HashSet<Track>> allTracks, ResourceManager manager, ProfilerFiller profiler) {
        selfTracks.clear();
        selfTracks.putAll(allTracks);
    }

    public static Map<ResourceLocation, HashSet<Track>> parseTracks(String json) {
        HashMap<ResourceLocation, HashSet<Track>> tracks = new HashMap<ResourceLocation, HashSet<Track>>();
        try {
            JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
            for (Map.Entry entry : root.entrySet()) {
                ResourceLocation id = ResourceLocation.tryParse((String)((String)entry.getKey()));
                if (id == null) {
                    NullCore.LOGGER.warn("Invalid element ID: {}", entry.getKey());
                    continue;
                }
                HashSet<Track> selfTracks = TracksManager.parseTrackList(((JsonElement)entry.getValue()).getAsJsonArray());
                tracks.put(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)id.getPath()), selfTracks);
            }
        }
        catch (Exception e) {
            NullCore.LOGGER.info("Failed to parse tracks JSON: {}", (Object)e.getMessage());
        }
        return tracks;
    }

    private static HashSet<Track> parseTrackList(JsonArray array) {
        HashSet<Track> tracks = new HashSet<Track>();
        for (JsonElement element : array) {
            try {
                DataResult result = Track.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                if (!result.result().isPresent()) continue;
                tracks.add((Track)result.result().get());
            }
            catch (Exception e) {
                NullCore.LOGGER.warn("Failed to parse track element: {}", (Object)element, (Object)e);
            }
        }
        return tracks;
    }
}

