/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.managers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mw.nullcore.NullCore;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;

public final class BiomeRulesManager
extends class_4080<Map<class_2960, BiomeRules>> {
    private static final Map<String, RuleType<?>> ruleTypes = new HashMap();
    private static final Map<class_2960, BiomeRules> biomeRules = new HashMap<class_2960, BiomeRules>();

    public Map<class_2960, BiomeRules> prepare(class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, BiomeRules> rules = new HashMap<class_2960, BiomeRules>();
        Map resources = manager.method_14488("level", id -> id.method_12832().endsWith("biome_rules.json"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    String json = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
                    for (Map.Entry biomeEntry : root.entrySet()) {
                        class_2960 biomeId = class_2960.method_12829((String)((String)biomeEntry.getKey()));
                        BiomeRules biomeRule = BiomeRulesManager.parseBiomeRules(((JsonElement)biomeEntry.getValue()).getAsJsonObject());
                        if (biomeRule.isEmpty()) continue;
                        rules.put(biomeId, biomeRule);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                NullCore.LOG.error("Failed to load biome rules from {}: {}", entry.getKey(), (Object)e.getMessage());
            }
        }
        return rules;
    }

    public void apply(Map<class_2960, BiomeRules> rules, class_3300 manager, class_3695 profiler) {
        biomeRules.clear();
        biomeRules.putAll(rules);
    }

    public static BiomeRules parseBiomeRules(JsonObject biomeJson) {
        BiomeRules rules = new BiomeRules();
        for (Map.Entry ruleEntry : biomeJson.entrySet()) {
            RuleType<?> type = ruleTypes.get(ruleEntry.getKey());
            if (type == null) {
                NullCore.LOG.warn("Unknown rule type: {}", ruleEntry.getKey());
                continue;
            }
            try {
                rules.addRule((String)ruleEntry.getKey(), type.parse((JsonElement)ruleEntry.getValue()));
            }
            catch (Exception e) {
                NullCore.LOG.warn("Invalid rule format for {}: {}", ruleEntry.getKey(), (Object)e.getMessage());
            }
        }
        return rules;
    }

    public static Optional<BiomeRules> getRules(class_2960 biomeId) {
        return Optional.ofNullable(biomeRules.get(biomeId));
    }

    public static <T> void registerRuleType(String key, Function<JsonElement, T> parser, Class<T> type) {
        ruleTypes.put(key, new RuleType<T>(parser, type));
    }

    static {
        BiomeRulesManager.registerRuleType("fixed_time", JsonElement::getAsLong, Long.class);
        BiomeRulesManager.registerRuleType("rain_force", JsonElement::getAsFloat, Float.class);
        BiomeRulesManager.registerRuleType("has_precipitation", JsonElement::getAsBoolean, Boolean.class);
    }

    public static class BiomeRules {
        private final Map<String, Object> rules = new HashMap<String, Object>();

        public <T> void addRule(String key, T value) {
            this.rules.put(key, value);
        }

        public <T> Optional<T> getRule(String key, Class<T> type) {
            Object value = this.rules.get(key);
            return type.isInstance(value) ? Optional.of(value) : Optional.empty();
        }

        public boolean isEmpty() {
            return this.rules.isEmpty();
        }
    }

    private record RuleType<T>(Function<JsonElement, T> parser, Class<T> type) {
        public T parse(JsonElement json) {
            return this.parser.apply(json);
        }
    }
}

