/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.client.audio;

import com.mw.nullcore.Utils;
import com.mw.nullcore.client.NullConfig;
import com.mw.nullcore.client.audio.Fading;
import com.mw.nullcore.client.audio.Track;
import com.mw.nullcore.core.managers.TracksManager;
import com.mw.nullcore.core.mixin.SoundManagerAccessor;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public final class TrackerTicker {
    @NotNull
    final class_310 mc = class_310.method_1551();
    private TrackAmbient track;
    private Track selectedTrack;
    private int timeNextTrack = 300;
    public class_2960 currentStage;

    public void tick() {
        if (this.mc.field_1724 == null || this.mc.field_1687 == null) {
            return;
        }
        class_2960 id = this.getStage((class_1937)this.mc.field_1687, this.mc.field_1724.method_24515());
        if (this.selectedTrack == null || this.timeNextTrack == 0) {
            this.selectedTrack = null;
            HashSet<Track> tracks = TracksManager.selfTracks.get(id);
            if (tracks != null) {
                this.selectedTrack = this.getTrack(tracks, (class_1937)this.mc.field_1687);
            }
        }
        if (id != this.currentStage) {
            this.stop(this.mc.field_1687.field_9229);
        }
        this.currentStage = id;
        if (this.canPlay()) {
            this.play(this.selectedTrack, this.mc.field_1687.field_9229);
        }
    }

    private class_2960 getStage(class_1937 level, class_2338 pos) {
        for (class_1297 entity : Utils.Level.getEntities(level, pos, NullConfig.radiusEntityTrack.get().byteValue())) {
            class_2960 entityId = class_1299.method_5890((class_1299)entity.method_5864());
            if (!TracksManager.selfTracks.containsKey(entityId)) continue;
            return entityId;
        }
        for (class_2960 structureId : TracksManager.selfTracks.keySet()) {
            class_3218 sl;
            if (!(level instanceof class_3218) || !Utils.Level.isStructure((class_1937)(sl = (class_3218)level), pos, structureId)) continue;
            return structureId;
        }
        return level.method_27983().method_29177();
    }

    private boolean canPlay() {
        if (this.selectedTrack == null) {
            return false;
        }
        if (this.track != null && this.mc.method_1483().method_4877((class_1113)this.track)) {
            return false;
        }
        if (this.timeNextTrack > 0) {
            --this.timeNextTrack;
            return false;
        }
        return true;
    }

    private Track getTrack(HashSet<Track> trackList, class_1937 level) {
        List tl = trackList.stream().toList();
        return trackList.size() > 1 ? (Track)tl.get(level.field_9229.method_43048(trackList.size())) : (Track)tl.get(0);
    }

    public void play(Track track, class_5819 rand) {
        ((Fading)((SoundManagerAccessor)this.mc.method_1483()).getSoundEngine()).setFade(true);
        this.track = new TrackAmbient(track.getSound(), class_3419.field_15253);
        this.track.setTick(45);
        this.mc.method_1483().method_4873((class_1113)this.track);
        this.timeNextTrack = class_3532.method_15395((class_5819)rand, (int)track.minDelay(), (int)track.maxDelay());
    }

    public void stop(class_5819 rand) {
        if (this.track != null) {
            this.track.fade = true;
            this.track = null;
            this.timeNextTrack = class_3532.method_15395((class_5819)rand, (int)100, (int)300);
        }
    }

    public boolean playingTrack() {
        return this.track != null;
    }

    public boolean isMusic(class_1113 sound) {
        return this.track == sound;
    }

    public static class TrackAmbient
    extends class_1101 {
        private int tick;
        public boolean fade;

        protected TrackAmbient(class_3414 sound, class_3419 source) {
            super(sound, source, class_1113.method_43221());
        }

        public void method_16896() {
            if (this.tick >= 0) {
                this.tick = !this.fade ? ++this.tick : --this.tick;
                this.setTick(Math.min(this.tick, 45));
                this.setVolume(Math.max(0.0f, Math.min((float)this.tick / 45.0f, 1.0f)));
            } else {
                this.method_24876();
            }
        }

        public void setVolume(float volume) {
            this.field_5442 = volume;
        }

        public void setTick(int tick) {
            this.tick = tick;
        }
    }
}

