/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.managers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.mw.nullcore.NullCore;
import com.mw.nullcore.Utils;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public final class LockableManager
extends class_4080<Map<class_2960, LockableEntry>> {
    public static final Map<class_2960, LockableEntry> selfLockable = new HashMap<class_2960, LockableEntry>();

    public Map<class_2960, LockableEntry> prepare(class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, LockableEntry> lockable = new HashMap<class_2960, LockableEntry>();
        Map resources = manager.method_14488("level", id -> id.method_12832().endsWith("lockable.json"));
        for (Map.Entry entry : resources.entrySet()) {
            try {
                InputStream stream = ((class_3298)entry.getValue()).method_14482();
                try {
                    String jsonContent = new String(stream.readAllBytes(), StandardCharsets.UTF_8);
                    Map<class_2960, LockableEntry> parsedData = LockableManager.parseLockable(jsonContent);
                    lockable.putAll(parsedData);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (Exception e) {
                NullCore.LOG.error("Failed to load lockable from {}: {}", entry.getKey(), (Object)e.getMessage());
            }
        }
        return lockable;
    }

    public void apply(Map<class_2960, LockableEntry> allLockable, class_3300 manager, class_3695 profiler) {
        selfLockable.clear();
        selfLockable.putAll(allLockable);
    }

    public static Map<class_2960, LockableEntry> parseLockable(String json) {
        HashMap<class_2960, LockableEntry> lockable = new HashMap<class_2960, LockableEntry>();
        try {
            JsonObject root = JsonParser.parseString((String)json).getAsJsonObject();
            for (Map.Entry entry : root.entrySet()) {
                class_2960 id = class_2960.method_12829((String)((String)entry.getKey()));
                if (id == null) {
                    NullCore.LOG.warn("Invalid resource ID: {}", entry.getKey());
                    continue;
                }
                if (!((JsonElement)entry.getValue()).isJsonObject()) continue;
                JsonObject entryObj = ((JsonElement)entry.getValue()).getAsJsonObject();
                LockableEntry lockableEntry = LockableManager.parseLockableEntry(entryObj);
                lockable.put(id, lockableEntry);
            }
        }
        catch (JsonParseException e) {
            NullCore.LOG.error("Failed to parse lockable JSON: {}", (Object)e.getMessage());
        }
        return lockable;
    }

    private static LockableEntry parseLockableEntry(JsonObject json) {
        class_2960 soundId;
        boolean lock = false;
        if (json.has("lock")) {
            JsonObject requiredObj = json.getAsJsonObject("lock");
            lock = requiredObj.getAsBoolean();
        }
        RequiredCondition required = null;
        if (json.has("required")) {
            JsonObject requiredObj = json.getAsJsonObject("required");
            class_2960 advancement = requiredObj.has("advancement") ? class_2960.method_12829((String)requiredObj.get("advancement").getAsString()) : null;
            required = new RequiredCondition(advancement);
        }
        class_5250 message = null;
        if (json.has("message")) {
            JsonElement messageElem = json.get("message");
            if (messageElem.isJsonObject()) {
                JsonObject ms = messageElem.getAsJsonObject();
                String text = ms.get("text").getAsString();
                message = class_2561.method_43471((String)text);
                if (ms.has("color")) {
                    JsonElement color = ms.get("color");
                    message = message.method_27661().method_54663(color.getAsJsonPrimitive().isNumber() ? color.getAsInt() : Utils.Color.hexPack(color.getAsString()));
                }
            } else {
                message = class_2561.method_43471((String)messageElem.getAsString());
            }
        }
        class_3414 soundMessage = null;
        if (json.has("sound_message") && (soundId = class_2960.method_12829((String)json.get("sound_message").getAsString())) != null) {
            soundMessage = (class_3414)class_7923.field_41172.method_63535(soundId);
        }
        ArrayList<class_1792> ignoreItems = new ArrayList<class_1792>();
        if (json.has("ignore")) {
            JsonArray ignoreArray = json.getAsJsonArray("ignore");
            for (JsonElement element : ignoreArray) {
                class_2960 itemId = class_2960.method_12829((String)element.getAsString());
                if (itemId == null) continue;
                class_1792 item = (class_1792)class_7923.field_41178.method_63535(itemId);
                ignoreItems.add(item);
            }
        }
        return new LockableEntry(lock, required, (class_2561)message, soundMessage, ignoreItems);
    }

    public static boolean canBlocked(class_3222 player, class_1268 hand, class_2338 pos, class_3218 level) {
        for (class_2960 id : selfLockable.keySet()) {
            if (!Utils.Level.isStructure((class_1937)level, pos, id) && !level.method_23753(pos).method_40226(id)) continue;
            LockableEntry entry = selfLockable.get(id);
            class_1799 itemInHand = player.method_5998(hand);
            if (!entry.lock()) {
                RequiredCondition required = entry.required();
                if (required == null) {
                    return false;
                }
                if (!Utils.Client.checkAdvancement(player, required.advancement())) {
                    if (entry.ignoreItems() == null || entry.ignoreItems().contains(itemInHand.method_7909())) continue;
                    LockableManager.sendLockMessage((class_1657)player, entry, (class_1937)level);
                    return true;
                }
                return false;
            }
            if (entry.ignoreItems() != null && entry.ignoreItems().contains(itemInHand.method_7909())) {
                return false;
            }
            LockableManager.sendLockMessage((class_1657)player, entry, (class_1937)level);
            return true;
        }
        return false;
    }

    private static void sendLockMessage(class_1657 player, LockableEntry entry, class_1937 level) {
        Utils.Text.sendMessage(player, entry.message());
        if (entry.soundMessage() != null) {
            level.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), entry.soundMessage(), class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public record LockableEntry(boolean lock, RequiredCondition required, class_2561 message, class_3414 soundMessage, List<class_1792> ignoreItems) {
    }

    public record RequiredCondition(class_2960 advancement) {
    }
}

