/*
 * Decompiled with CFR 0.152.
 */
package com.mw.nullcore.core.items.armor;

import com.mw.nullcore.Utils;
import com.mw.nullcore.core.builders.ArmorMaterialBuilder;
import com.mw.nullcore.core.items.armor.SuitItem;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.equipment.ArmorMaterial;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CompactSuitItem
extends Item {
    final ArmorMaterial material;

    public CompactSuitItem(Item.Properties prop, ArmorMaterial material) {
        super(prop.stacksTo(1).durability(material.durability() * SuitItem.getSet(material).size()).enchantable(material.enchantmentValue()));
        this.material = material;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        if (this.equipArmorSet(player)) {
            ItemStack stack = player.getItemInHand(hand);
            player.getCooldowns().addCooldown(stack, 20);
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        ArmorMaterialBuilder.ShyEffect[] effects = ArmorMaterialBuilder.effects.get(this.getMaterial());
        Utils.Text.addTooltipEffects(tooltip, Component.translatable((String)"tooltip.nullcore.suitinfo2").withStyle(ChatFormatting.GRAY), Arrays.stream(effects).toList());
    }

    private boolean equipArmorSet(Player player) {
        Inventory inv = player.getInventory();
        for (ArmorType type : ArmorType.values()) {
            ItemStack armor = inv.getArmor(type.getSlot().getIndex());
            if (armor.isEmpty()) continue;
            return false;
        }
        for (Map.Entry entry : SuitItem.getSet(this.getMaterial()).entrySet()) {
            ArmorType type = (ArmorType)entry.getKey();
            ItemStack armorStack = ((ItemStack)entry.getValue()).copy();
            inv.armor.set(type.getSlot().getIndex(), (Object)armorStack);
        }
        return true;
    }

    public static ItemStack returnCompact(Player player, ItemStack armorStack, ClickType click) {
        CompactSuitItem compact;
        ArmorMaterial material = CompactSuitItem.getArmorMaterial(armorStack);
        if (material != null && (compact = CompactSuitItem.findCompact(material)) != null) {
            ItemStack comp = new ItemStack((ItemLike)compact);
            Inventory inv = player.getInventory();
            if (click != ClickType.CLONE) {
                for (ArmorType type : ArmorType.values()) {
                    inv.armor.set(type.getSlot().getIndex(), (Object)ItemStack.EMPTY);
                }
            }
            return comp;
        }
        return ItemStack.EMPTY;
    }

    private static CompactSuitItem findCompact(ArmorMaterial material) {
        for (Item item : BuiltInRegistries.ITEM) {
            CompactSuitItem compact;
            if (!(item instanceof CompactSuitItem) || (compact = (CompactSuitItem)item).getMaterial() != material) continue;
            return compact;
        }
        return null;
    }

    private static ArmorMaterial getArmorMaterial(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof SuitItem) {
            SuitItem armor = (SuitItem)item;
            return armor.getMaterial();
        }
        return null;
    }

    public ArmorMaterial getMaterial() {
        return this.material;
    }
}

