/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.enchantment_lore;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class EnchantmentLore {
    public static final String NAMESPACE = "enchantment_lore";
    private static final String NAMESPACE_DOT = "enchantment_lore.";
    public static final class_5250 CONTAINS_NO_ENCHANTMENTS = class_2561.method_43471((String)"enchantment_lore.contains_no_enchantments");
    public static final int LINES_PER_PAGE = 14;
    private static Side SIDE;

    public static void setSide(@NotNull Side side) {
        SIDE = Objects.requireNonNull(side);
    }

    public static class_1269 useEnchantedBook(class_1657 user, class_1937 world, class_1268 hand) {
        class_1799 usedStack = user.method_5998(hand);
        if (SIDE.isClient() != world.method_8608() || usedStack.method_7909() != class_1802.field_8598) {
            return class_1269.field_5811;
        }
        List<String> storedEnchantmentIds = class_1890.method_57532((class_1799)usedStack).method_57534().stream().map(class_6880::method_40230).flatMap(Optional::stream).map(class_5321::method_29177).map(Object::toString).toList();
        ArrayList<class_2561> pages = new ArrayList<class_2561>();
        if (storedEnchantmentIds.isEmpty()) {
            pages.add((class_2561)CONTAINS_NO_ENCHANTMENTS);
        } else {
            for (String id : storedEnchantmentIds) {
                Optional<class_2561> lore;
                boolean lorePresent;
                Optional<class_2561> description = EnchantmentLore.getTranslation(NAMESPACE_DOT + id + ".description");
                boolean descriptionPresent = description.isPresent();
                if (descriptionPresent) {
                    pages.addAll(SIDE.wrapPages(description.orElseThrow()));
                }
                if (lorePresent = (lore = EnchantmentLore.getTranslation(NAMESPACE_DOT + id + ".lore")).isPresent()) {
                    pages.addAll(SIDE.wrapPages(lore.orElseThrow()));
                }
                if (descriptionPresent || lorePresent) continue;
                pages.add((class_2561)class_2561.method_43471((String)"enchantment_lore.no_translation_for").method_27661().method_27693(id));
            }
        }
        SIDE.openScreen(pages, user);
        return SIDE.getSuccessResult();
    }

    private static Optional<class_2561> getTranslation(String key) {
        class_5250 translation;
        if (SIDE.hasTranslation(key) && !(translation = class_2561.method_43471((String)key)).getString().isEmpty()) {
            return Optional.of(translation);
        }
        return Optional.empty();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Side {
        public boolean isClient();

        public void openScreen(List<class_2561> var1, class_1657 var2);

        public boolean hasTranslation(String var1);

        public List<class_2561> wrapPages(class_2561 var1);

        public class_1269 getSuccessResult();
    }
}

