/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepass.config;

import com.mrbysco.telepass.Constants;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class TeleConfig {
    public static final ModConfigSpec commonSpec;
    public static final Common COMMON;

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        Constants.LOGGER.debug("Loaded TelePass' config file {}", (Object)configEvent.getConfig().getFileName());
    }

    @SubscribeEvent
    public static void onFileChange(ModConfigEvent.Reloading configEvent) {
        Constants.LOGGER.warn("TelePass' config just got changed on the file system!");
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(Common::new);
        commonSpec = (ModConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
    }

    public static class Common {
        public final ModConfigSpec.IntValue goldDurability;
        public final ModConfigSpec.IntValue diamondDurability;

        Common(ModConfigSpec.Builder builder) {
            builder.comment("General settings").push("general");
            this.goldDurability = builder.comment("Defines the amount of uses the Gold TelePass has [Default: 15]").defineInRange("goldDurability", 15, 0, Integer.MAX_VALUE);
            this.diamondDurability = builder.comment("Defines the amount of uses the Diamond TelePass has [Default: 1000]").defineInRange("diamondDurability", 1000, 0, Integer.MAX_VALUE);
            builder.pop();
        }
    }
}

