/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.telepass.item;

import com.mrbysco.telepass.item.CompassMaterial;
import com.mrbysco.telepass.platform.Services;
import com.mrbysco.telepass.registration.TeleDataComponents;
import com.mrbysco.telepass.util.PlayerUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeleCompass
extends Item {
    protected final CompassMaterial material;

    public TeleCompass(Item.Properties properties, CompassMaterial material) {
        super(properties);
        this.material = material;
    }

    @NotNull
    public InteractionResult use(Level level, Player player, @NotNull InteractionHand handIn) {
        ItemStack itemstack = player.getItemInHand(handIn);
        if (!level.isClientSide() && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (itemstack.has(TeleDataComponents.OWNER.get())) {
                String ownerName = (String)itemstack.getOrDefault(TeleDataComponents.OWNER.get(), (Object)"");
                if (ownerName.isEmpty()) {
                    return InteractionResult.PASS;
                }
                if (ownerName.equalsIgnoreCase(player.getGameProfile().name())) {
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.telepass.self"));
                    return InteractionResult.SUCCESS;
                }
                Player owner = PlayerUtil.getPlayerEntityByName(level, ownerName);
                if (owner != null) {
                    if (!owner.level().dimension().equals(player.level().dimension())) {
                        serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.telepass.dimension", (Object[])new Object[]{String.valueOf(ChatFormatting.RED) + ownerName}));
                        return InteractionResult.SUCCESS;
                    }
                    if (!player.getAbilities().instabuild) {
                        itemstack.hurtAndBreak(1, (LivingEntity)player, handIn == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    }
                    if (Services.PLATFORM.notFakePlayer(player)) {
                        level.playSound((Entity)((Player)null), player.getX(), player.getY(), player.getZ(), SoundEvents.CHORUS_FRUIT_TELEPORT, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.random.nextFloat() * 0.4f + 0.8f));
                        player.getCooldowns().addCooldown(itemstack, 20);
                        player.teleportTo(owner.getX(), owner.getY(), owner.getZ());
                    }
                } else {
                    serverPlayer.sendSystemMessage((Component)Component.translatable((String)"item.telepass.offline", (Object[])new Object[]{String.valueOf(ChatFormatting.RED) + ownerName}));
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void inventoryTick(@NotNull ItemStack stack, ServerLevel level, @NotNull Entity entity, @Nullable EquipmentSlot slot) {
        Player player;
        if (!level.isClientSide() && !stack.has(TeleDataComponents.OWNER.get()) && entity instanceof Player && Services.PLATFORM.notFakePlayer(player = (Player)entity)) {
            stack.set(TeleDataComponents.OWNER.get(), (Object)player.getGameProfile().name());
        }
        super.inventoryTick(stack, level, entity, slot);
    }

    @NotNull
    public Component getName(ItemStack stack) {
        if (stack.has(TeleDataComponents.OWNER.get())) {
            String owner = (String)stack.getOrDefault(TeleDataComponents.OWNER.get(), (Object)"");
            if (owner.isEmpty()) {
                return super.getName(stack);
            }
            return Component.literal((String)(owner + "'s ")).append((Component)Component.translatable((String)this.getDescriptionId()));
        }
        return super.getName(stack);
    }
}

