/*
 * Decompiled with CFR 0.152.
 */
package net.dimaskama.mcef.impl;

import java.util.concurrent.CompletableFuture;
import me.friwi.jcefmaven.CefAppBuilder;
import me.friwi.jcefmaven.EnumProgress;
import me.friwi.jcefmaven.IProgressHandler;
import net.dimaskama.mcef.api.MCEFApi;
import net.dimaskama.mcef.api.MCEFBrowser;
import net.dimaskama.mcef.impl.MCEFBrowserImpl;
import net.dimaskama.mcef.impl.MCEFModern;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefRequestContext;
import org.jetbrains.annotations.Nullable;

public class MCEFApiImpl
implements MCEFApi {
    private static volatile InitializationImpl initialization;
    private final CefApp cefApp;
    private final CefClient client;

    private MCEFApiImpl(InitializationImpl initialization) throws Exception {
        CefAppBuilder cefAppBuilder = new CefAppBuilder();
        cefAppBuilder.setInstallDir(MCEFModern.JCEF_PATH.toFile());
        cefAppBuilder.setProgressHandler((IProgressHandler)initialization);
        cefAppBuilder.addJcefArgs(new String[]{"--autoplay-policy=no-user-gesture-required", "--disable-web-security", "--enable-widevine-cdm"});
        this.cefApp = cefAppBuilder.build();
        CefSettings cefSettings = new CefSettings();
        cefSettings.user_agent_product = "MCEF-Modern/0";
        cefSettings.root_cache_path = MCEFModern.CACHE_PATH.toAbsolutePath().toString();
        this.cefApp.setSettings(cefSettings);
        this.client = this.cefApp.createClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MCEFApi.Initialization initialize() {
        if (initialization != null) return initialization;
        Class<MCEFApiImpl> clazz = MCEFApiImpl.class;
        synchronized (MCEFApiImpl.class) {
            if (initialization != null) return initialization;
            initialization = new InitializationImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return initialization;
        }
    }

    @Nullable
    public static MCEFApi.Initialization getInitialization() {
        return initialization;
    }

    @Override
    public MCEFBrowser createBrowser(String url, boolean transparent) {
        MCEFBrowserImpl browser = new MCEFBrowserImpl(this.client, url, transparent, CefRequestContext.getGlobalContext(), null);
        browser.setCloseAllowed();
        browser.createImmediately();
        return browser;
    }

    public void close() {
        this.cefApp.dispose();
    }

    private static class InitializationImpl
    implements MCEFApi.Initialization,
    IProgressHandler {
        private final CompletableFuture<MCEFApi> future;
        private volatile MCEFApi.Initialization.Stage stage = MCEFApi.Initialization.Stage.NOT_STARTED;
        private volatile float percentage = -1.0f;

        private InitializationImpl() {
            this.future = CompletableFuture.supplyAsync(() -> {
                try {
                    return new MCEFApiImpl(this);
                }
                catch (Throwable e) {
                    MCEFModern.LOGGER.error("Failed to initialize MCEF Modern", e);
                    this.stage = MCEFApi.Initialization.Stage.DONE;
                    this.percentage = -1.0f;
                    throw new RuntimeException("Failed to initialize MCEF Modern", e);
                }
            });
        }

        @Override
        public MCEFApi.Initialization.Stage getStage() {
            return this.stage;
        }

        @Override
        public float getPercentage() {
            return this.percentage;
        }

        @Override
        public CompletableFuture<MCEFApi> getFuture() {
            return this.future;
        }

        public void handleProgress(EnumProgress state, float percent) {
            this.stage = switch (state) {
                default -> throw new MatchException(null, null);
                case EnumProgress.LOCATING -> MCEFApi.Initialization.Stage.NOT_STARTED;
                case EnumProgress.DOWNLOADING -> MCEFApi.Initialization.Stage.DOWNLOADING;
                case EnumProgress.EXTRACTING -> MCEFApi.Initialization.Stage.EXTRACTING;
                case EnumProgress.INSTALL -> MCEFApi.Initialization.Stage.INSTALL;
                case EnumProgress.INITIALIZING -> MCEFApi.Initialization.Stage.INITIALIZING;
                case EnumProgress.INITIALIZED -> MCEFApi.Initialization.Stage.DONE;
            };
            this.percentage = percent;
        }
    }
}

