/*
 * Decompiled with CFR 0.152.
 */
package net.dimaskama.mcef.impl;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.textures.TextureFormat;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import net.dimaskama.mcef.api.MCEFBrowser;
import net.dimaskama.mcef.impl.ExtraCursorTypes;
import net.minecraft.class_10868;
import net.minecraft.class_11875;
import net.minecraft.class_11876;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_310;
import org.cef.CefBrowserSettings;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefRequestContext;
import org.cef.browser.CustomCefBrowserOsr;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

public class MCEFBrowserImpl
extends CustomCefBrowserOsr
implements MCEFBrowser {
    @Nullable
    private GpuTexture gpuTexture;
    @Nullable
    private GpuTextureView gpuTextureView;
    private int lastPressedMouseButton = 0;
    private boolean lastMouseEntered;
    private int cursorType = 0;

    public MCEFBrowserImpl(CefClient client, String url, boolean transparent, CefRequestContext context, CefBrowserSettings settings) {
        super(client, url, transparent, context, settings);
    }

    @Override
    public void resize(int width, int height) {
        this.browserRect.setBounds(0, 0, width, height);
        this.wasResized(width, height);
    }

    @Override
    public void onMouseClicked(class_11909 event, boolean doubled) {
        int btn;
        this.lastPressedMouseButton = btn = MCEFBrowserImpl.toAwtMouseButton(event.method_74245());
        this.sendMouseEvent(new MouseEvent(this.component, 501, System.currentTimeMillis(), MCEFBrowserImpl.toAwtInputModifiers(event.comp_4797()), (int)event.comp_4798(), (int)event.comp_4799(), doubled ? 2 : 1, false, btn));
    }

    @Override
    public void onMouseReleased(class_11909 event) {
        int btn = MCEFBrowserImpl.toAwtMouseButton(event.method_74245());
        if (btn == this.lastPressedMouseButton) {
            this.lastPressedMouseButton = 0;
        }
        this.sendMouseEvent(new MouseEvent(this.component, 502, System.currentTimeMillis(), MCEFBrowserImpl.toAwtInputModifiers(event.comp_4797()), (int)event.comp_4798(), (int)event.comp_4799(), 1, false, btn));
    }

    @Override
    public void onMouseScrolled(int x, int y, double amount) {
        this.sendMouseWheelEvent(new MouseWheelEvent(this.component, 0, System.currentTimeMillis(), 0, x, y, 0, false, 0, 100, (int)Math.signum(amount)));
    }

    @Override
    public void onMouseMoved(int x, int y) {
        boolean mouseEntered = this.browserRect.contains(x, y);
        if (mouseEntered != this.lastMouseEntered) {
            this.lastMouseEntered = mouseEntered;
            this.sendMouseEvent(new MouseEvent(this.component, mouseEntered ? 504 : 505, System.currentTimeMillis(), 0, x, y, 0, false, 0));
        }
        boolean dragging = this.lastPressedMouseButton != 0;
        this.sendMouseEvent(new MouseEvent(this.component, dragging ? 506 : 503, System.currentTimeMillis(), 0, x, y, 0, false, dragging ? this.lastPressedMouseButton : 0));
    }

    @Override
    public void onKeyPressed(class_11908 event) {
        int key = MCEFBrowserImpl.toAwtKeyCode(event.comp_4795());
        this.sendKeyEvent(new KeyEvent(this.component, 401, System.currentTimeMillis(), MCEFBrowserImpl.toAwtInputModifiers(event.comp_4797()), key, (char)key));
    }

    @Override
    public void onKeyReleased(class_11908 event) {
        int key = MCEFBrowserImpl.toAwtKeyCode(event.comp_4795());
        this.sendKeyEvent(new KeyEvent(this.component, 402, System.currentTimeMillis(), MCEFBrowserImpl.toAwtInputModifiers(event.comp_4797()), key, (char)key));
    }

    @Override
    public void onCharTyped(class_11905 event) {
        this.sendKeyEvent(new KeyEvent(this.component, 400, System.currentTimeMillis(), MCEFBrowserImpl.toAwtInputModifiers(event.comp_4794()), 0, (char)event.comp_4793()));
    }

    @Override
    @Nullable
    public GpuTexture getTexture() {
        return this.gpuTexture;
    }

    @Override
    @Nullable
    public GpuTextureView getTextureView() {
        return this.gpuTextureView;
    }

    @Override
    public class_11875 getCursorType() {
        return switch (this.cursorType) {
            case 1 -> class_11876.field_62454;
            case 2 -> class_11876.field_62453;
            case 4, 7 -> ExtraCursorTypes.RESIZE_NESW;
            case 5, 6 -> ExtraCursorTypes.RESIZE_NWSE;
            case 8, 9 -> class_11876.field_62456;
            case 10, 11 -> class_11876.field_62457;
            case 12 -> class_11876.field_62455;
            case 13 -> class_11876.field_62452;
            default -> class_11876.field_62452;
        };
    }

    @Override
    public void close() {
        if (this.gpuTextureView != null) {
            this.gpuTextureView.close();
            this.gpuTextureView = null;
        }
        if (this.gpuTexture != null) {
            this.gpuTexture.close();
            this.gpuTexture = null;
        }
        this.close(true);
    }

    @Override
    public CefBrowser getCefBrowser() {
        return this;
    }

    private static int toAwtInputModifiers(int mod) {
        int awtMod = 0;
        if ((mod & 1) != 0) {
            awtMod |= 0x40;
        }
        if ((mod & 2) != 0) {
            awtMod |= 0x80;
        }
        if ((mod & 4) != 0) {
            awtMod |= 0x200;
        }
        if ((mod & 8) != 0) {
            awtMod |= 0x100;
        }
        return awtMod;
    }

    private static int toAwtMouseButton(int button) {
        return switch (button) {
            case 1 -> 3;
            case 2 -> 2;
            default -> 1;
        };
    }

    private static int toAwtKeyCode(int glfwKey) {
        return switch (glfwKey) {
            case 32 -> 32;
            case 39 -> 222;
            case 44 -> 44;
            case 45 -> 45;
            case 46 -> 46;
            case 47 -> 47;
            case 48 -> 48;
            case 49 -> 49;
            case 50 -> 50;
            case 51 -> 51;
            case 52 -> 52;
            case 53 -> 53;
            case 54 -> 54;
            case 55 -> 55;
            case 56 -> 56;
            case 57 -> 57;
            case 65 -> 65;
            case 66 -> 66;
            case 67 -> 67;
            case 68 -> 68;
            case 69 -> 69;
            case 70 -> 70;
            case 71 -> 71;
            case 72 -> 72;
            case 73 -> 73;
            case 74 -> 74;
            case 75 -> 75;
            case 76 -> 76;
            case 77 -> 77;
            case 78 -> 78;
            case 79 -> 79;
            case 80 -> 80;
            case 81 -> 81;
            case 82 -> 82;
            case 83 -> 83;
            case 84 -> 84;
            case 85 -> 85;
            case 86 -> 86;
            case 87 -> 87;
            case 88 -> 88;
            case 89 -> 89;
            case 90 -> 90;
            case 256 -> 27;
            case 257 -> 10;
            case 258 -> 9;
            case 259 -> 8;
            case 260 -> 155;
            case 261 -> 127;
            case 262 -> 39;
            case 263 -> 37;
            case 264 -> 40;
            case 265 -> 38;
            case 266 -> 33;
            case 267 -> 34;
            case 268 -> 36;
            case 269 -> 35;
            case 280 -> 20;
            case 281 -> 145;
            case 282 -> 144;
            case 283 -> 154;
            case 284 -> 19;
            case 340, 344 -> 16;
            case 341, 345 -> 17;
            case 342, 346 -> 18;
            case 343, 347 -> 157;
            case 290 -> 112;
            case 291 -> 113;
            case 292 -> 114;
            case 293 -> 115;
            case 294 -> 116;
            case 295 -> 117;
            case 296 -> 118;
            case 297 -> 119;
            case 298 -> 120;
            case 299 -> 121;
            case 300 -> 122;
            case 301 -> 123;
            case 320 -> 96;
            case 321 -> 97;
            case 322 -> 98;
            case 323 -> 99;
            case 324 -> 100;
            case 325 -> 101;
            case 326 -> 102;
            case 327 -> 103;
            case 328 -> 104;
            case 329 -> 105;
            case 330 -> 110;
            case 331 -> 111;
            case 332 -> 106;
            case 333 -> 109;
            case 334 -> 107;
            case 335 -> 10;
            case 336 -> 61;
            case 59 -> 59;
            case 61 -> 61;
            case 91 -> 91;
            case 93 -> 93;
            case 92 -> 92;
            case 96 -> 192;
            default -> 0;
        };
    }

    @Override
    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        ByteBuffer copy = MemoryUtil.memAlloc((int)buffer.capacity());
        MemoryUtil.memCopy((ByteBuffer)buffer, (ByteBuffer)copy);
        class_310.method_1551().method_20493(() -> this.onPaintInternal(popup, dirtyRects, copy, width, height));
        super.onPaint(browser, popup, dirtyRects, buffer, width, height);
    }

    private void onPaintInternal(boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        if (dirtyRects.length == 0) {
            return;
        }
        if (!popup) {
            if (this.gpuTexture == null || this.gpuTexture.getWidth(0) != width || this.gpuTexture.getHeight(0) != height) {
                if (this.gpuTextureView != null) {
                    this.gpuTextureView.close();
                }
                if (this.gpuTexture != null) {
                    this.gpuTexture.close();
                }
                this.gpuTexture = RenderSystem.getDevice().createTexture("MCEFBrowser", 15, TextureFormat.RGBA8, width, height, 1, 1);
                this.gpuTextureView = RenderSystem.getDevice().createTextureView(this.gpuTexture);
            }
            GlStateManager._bindTexture((int)((class_10868)this.gpuTexture).method_68427());
            GlStateManager._pixelStore((int)3314, (int)width);
            GlStateManager._pixelStore((int)3316, (int)0);
            GlStateManager._pixelStore((int)3315, (int)0);
            GlStateManager._pixelStore((int)3317, (int)4);
            GlStateManager._texSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)width, (int)height, (int)32993, (int)5121, (ByteBuffer)buffer);
        }
        MemoryUtil.memFree((Buffer)buffer);
    }

    @Override
    public boolean onCursorChange(CefBrowser browser, int cursorType) {
        this.cursorType = cursorType;
        return super.onCursorChange(browser, cursorType);
    }
}

