/*
 * Decompiled with CFR 0.152.
 */
package org.cef.browser;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.cef.CefBrowserSettings;
import org.cef.CefClient;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefBrowser_N;
import org.cef.browser.CefPaintEvent;
import org.cef.browser.CefRequestContext;
import org.cef.callback.CefDragData;
import org.cef.handler.CefClientHandler;
import org.cef.handler.CefRenderHandler;
import org.cef.handler.CefScreenInfo;

public class CustomCefBrowserOsr
extends CefBrowser_N
implements CefRenderHandler {
    protected final Rectangle browserRect = new Rectangle(0, 0, 1, 1);
    protected final Component component = new Component(){

        @Override
        public String getName() {
            return "CustomCefBrowserOsr";
        }

        @Override
        public int getWidth() {
            return (int)CustomCefBrowserOsr.this.browserRect.getWidth();
        }

        @Override
        public int getHeight() {
            return (int)CustomCefBrowserOsr.this.browserRect.getHeight();
        }
    };
    protected final boolean isTransparent;
    private final List<Consumer<CefPaintEvent>> onPaintListeners = new CopyOnWriteArrayList<Consumer<CefPaintEvent>>();

    public CustomCefBrowserOsr(CefClient client, String url, boolean transparent, CefRequestContext context, CefBrowserSettings settings) {
        super(client, url, context, null, null, settings);
        this.isTransparent = transparent;
    }

    public void createImmediately() {
        this.createBrowserIfRequired();
    }

    public Component getUIComponent() {
        return this.component;
    }

    public CefRenderHandler getRenderHandler() {
        return this;
    }

    protected CefBrowser_N createDevToolsBrowser(CefClient client, String url, CefRequestContext context, CefBrowser_N parent, Point inspectAt) {
        return null;
    }

    public Rectangle getViewRect(CefBrowser browser) {
        return this.browserRect;
    }

    public Point getScreenPoint(CefBrowser browser, Point viewPoint) {
        return new Point(viewPoint);
    }

    public void onPopupShow(CefBrowser browser, boolean show) {
    }

    public void onPopupSize(CefBrowser browser, Rectangle size) {
    }

    public void addOnPaintListener(Consumer<CefPaintEvent> listener) {
    }

    public void setOnPaintListener(Consumer<CefPaintEvent> listener) {
        this.onPaintListeners.clear();
        this.onPaintListeners.add(listener);
    }

    public void removeOnPaintListener(Consumer<CefPaintEvent> listener) {
        this.onPaintListeners.remove(listener);
    }

    public void onPaint(CefBrowser browser, boolean popup, Rectangle[] dirtyRects, ByteBuffer buffer, int width, int height) {
        if (!this.onPaintListeners.isEmpty()) {
            CefPaintEvent paintEvent = new CefPaintEvent(browser, popup, dirtyRects, buffer, width, height);
            for (Consumer<CefPaintEvent> l : this.onPaintListeners) {
                l.accept(paintEvent);
            }
        }
    }

    public boolean onCursorChange(CefBrowser browser, int cursorType) {
        return true;
    }

    public boolean startDragging(CefBrowser browser, CefDragData dragData, int mask, int x, int y) {
        return true;
    }

    public void updateDragCursor(CefBrowser browser, int operation) {
    }

    private void createBrowserIfRequired() {
        if (this.getNativeRef("CefBrowser") == 0L) {
            this.createBrowser((CefClientHandler)this.getClient(), 0L, this.getUrl(), true, this.isTransparent, null, this.getRequestContext());
        }
    }

    public boolean getScreenInfo(CefBrowser browser, CefScreenInfo screenInfo) {
        screenInfo.Set(1.0, 32, 8, false, this.browserRect.getBounds(), this.browserRect.getBounds());
        return true;
    }

    public CompletableFuture<BufferedImage> createScreenshot(boolean nativeResolution) {
        throw new UnsupportedOperationException();
    }
}

