/*
 * Decompiled with CFR 0.152.
 */
package fr.mtrfranceaddon.mod.common.block;

import fr.mtrfranceaddon.mod.common.registry.ModBlockEntities;
import fr.mtrfranceaddon.mod.common.registry.ModBlocks;
import org.mtr.mapping.holder.BlockPos;
import org.mtr.mapping.holder.BlockRenderType;
import org.mtr.mapping.holder.BlockSettings;
import org.mtr.mapping.holder.BlockState;
import org.mtr.mapping.holder.BlockView;
import org.mtr.mapping.holder.ClientPlayerEntity;
import org.mtr.mapping.holder.Direction;
import org.mtr.mapping.holder.Identifier;
import org.mtr.mapping.holder.MinecraftClient;
import org.mtr.mapping.holder.ShapeContext;
import org.mtr.mapping.holder.Vector3d;
import org.mtr.mapping.holder.VoxelShape;
import org.mtr.mapping.holder.VoxelShapes;
import org.mtr.mapping.mapper.BlockEntityExtension;
import org.mtr.mapping.mapper.BlockEntityRenderer;
import org.mtr.mapping.mapper.BlockWithEntity;
import org.mtr.mapping.mapper.GraphicsHolder;
import org.mtr.mod.InitClient;
import org.mtr.mod.block.BlockPlatform;
import org.mtr.mod.client.IDrawing;
import org.mtr.mod.render.MainRenderer;
import org.mtr.mod.render.QueuedRenderLayer;
import org.mtr.mod.render.RenderRails;
import org.mtr.mod.render.StoredMatrixTransformations;

public class InvisiblePlatform
extends BlockPlatform
implements BlockWithEntity {
    public InvisiblePlatform(BlockSettings settings) {
        super(settings.nonOpaque(), false);
    }

    public BlockRenderType getRenderType2(BlockState state) {
        return BlockRenderType.getEntityblockAnimatedMapped();
    }

    public BlockEntityExtension createBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new InvPlatBE(blockPos, blockState);
    }

    public VoxelShape getOutlineShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return VoxelShapes.fullCube();
    }

    public VoxelShape getCollisionShape2(BlockState state, BlockView world, BlockPos pos, ShapeContext context) {
        return VoxelShapes.fullCube();
    }

    public VoxelShape getCullingShape2(BlockState state, BlockView world, BlockPos pos) {
        return VoxelShapes.empty();
    }

    public float getAmbientOcclusionLightLevel2(BlockState state, BlockView world, BlockPos pos) {
        return 1.0f;
    }

    public static class InvPlatBE
    extends BlockEntityExtension {
        public InvPlatBE(BlockPos blockPos, BlockState blockState) {
            super(ModBlockEntities.INVISIBLE_PLATFORM.get(), blockPos, blockState);
        }
    }

    public static class InvPlatRenderer
    extends BlockEntityRenderer<InvPlatBE> {
        public InvPlatRenderer(BlockEntityRenderer.Argument dispatcher) {
            super(dispatcher);
        }

        public void render(InvPlatBE blockEntity, float tickDelta, GraphicsHolder graphicsHolder, int light, int overlay) {
            if (blockEntity.getWorld2() == null) {
                return;
            }
            MinecraftClient minecraftClient = MinecraftClient.getInstance();
            ClientPlayerEntity clientPlayerEntity = minecraftClient.getPlayerMapped();
            if (clientPlayerEntity == null) {
                return;
            }
            StoredMatrixTransformations storedMatrixTransformations = new StoredMatrixTransformations(0.5 + (double)blockEntity.getPos2().getX(), 0.5 + (double)blockEntity.getPos2().getY(), 0.5 + (double)blockEntity.getPos2().getZ());
            if ((RenderRails.isHoldingRailRelated((ClientPlayerEntity)clientPlayerEntity) || clientPlayerEntity.isHolding(ModBlocks.INVISIBLE_PLATFORM.get().asItem())) && minecraftClient.getCurrentScreenMapped() == null) {
                MainRenderer.scheduleRender((Identifier)new Identifier("mtrfranceaddon", "textures/item/invisible_platform.png"), (boolean)false, (QueuedRenderLayer)QueuedRenderLayer.LIGHT_TRANSLUCENT, (graphicsHolderNew, offset) -> {
                    storedMatrixTransformations.transform(graphicsHolderNew, offset);
                    InitClient.transformToFacePlayer((GraphicsHolder)graphicsHolderNew, (double)((double)blockEntity.getPos2().getX() + 0.5), (double)((double)blockEntity.getPos2().getY() + 0.5), (double)((double)blockEntity.getPos2().getZ() + 0.5));
                    graphicsHolderNew.rotateZDegrees(180.0f);
                    IDrawing.drawTexture((GraphicsHolder)graphicsHolderNew, (float)-0.5f, (float)-0.5f, (float)1.0f, (float)1.0f, (Direction)Direction.UP, (int)GraphicsHolder.getDefaultLight());
                    graphicsHolderNew.pop();
                });
            }
        }

        public boolean isInRenderDistance(InvPlatBE blockEntity, Vector3d position) {
            return true;
        }
    }
}

