package com.boyonk.sharedadvancements;

import com.google.common.base.Suppliers;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_1928;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_2989;
import net.minecraft.class_3222;
import net.minecraft.class_4284;
import net.minecraft.class_8779;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;

public abstract class GroupAdvancementTracker {
	private static final Logger LOGGER = LogUtils.getLogger();

	final MinecraftServer server;
	private final Supplier<Codec<ProgressMap>> progressMapCodec;

	private final Map<class_8779, class_167> progress = new LinkedHashMap<>();

	public GroupAdvancementTracker(@NotNull MinecraftServer server) {
		this.server = server;
		this.progressMapCodec = Suppliers.memoize(() -> class_4284.field_19220.method_53711(ProgressMap.CODEC, server.method_3855(), 1343));
	}

	abstract Stream<class_3222> getPlayers();

	abstract class_2561 getDisplayName();

	public boolean grantCriterion(class_8779 advancement, String criterionName, @Nullable class_3222 from) {
		if (advancement.comp_1920().comp_1913().isEmpty() && !SharedAdvancements.config().shareDisplayless()) return false;
		if (!((SharedAdvancement) (Object) advancement.comp_1920()).shared()) return false;

		boolean granted = false;
		class_167 progress = this.getProgress(advancement);
		boolean wasDone = progress.method_740();
		if (progress.method_743(criterionName)) {
			this.getPlayers().filter(player -> player != from).forEach(player -> player.method_14236().method_12878(advancement, criterionName));

			granted = true;
			if (!wasDone && progress.method_740()) {
				advancement.comp_1920().comp_1913().ifPresent(display -> {
					if (SharedAdvancements.config().mergeBroadcastMessage() && display.method_808() && this.server.method_3767().method_8355(class_1928.field_19409)) {
						this.server.method_3760().method_43514(class_2561.method_43469("chat.type.advancement." + display.method_815().method_15434(), from == null ? this.getDisplayName() : from.method_5476(), class_161.method_53622(advancement)), false);
					}
				});
			}
		}
		if (!wasDone && progress.method_740()) {
			this.onStatusUpdate(advancement);
		}
		return granted;
	}

	public boolean revokeCriterion(class_8779 advancement, String criterionName, @Nullable class_3222 from) {
		if (advancement.comp_1920().comp_1913().isEmpty() && !SharedAdvancements.config().shareDisplayless()) return false;
		if (!((SharedAdvancement) (Object) advancement.comp_1920()).shared()) return false;

		boolean revoked = false;
		class_167 progress = this.getProgress(advancement);
		boolean wasDone = progress.method_740();

		if (progress.method_729(criterionName)) {
			revoked = true;
			this.getPlayers().filter(player -> player != from).forEach(player -> player.method_14236().method_12883(advancement, criterionName));
		}
		if (wasDone && !progress.method_740()) {
			this.onStatusUpdate(advancement);
		}
		return revoked;
	}

	@SuppressWarnings("EmptyMethod")
	private void onStatusUpdate(class_8779 advancement) {

	}


	public class_167 getProgress(class_8779 advancement) {
		class_167 progress = this.progress.get(advancement);
		if (progress == null) {
			progress = new class_167();
			this.initProgress(advancement, progress);
		}
		return progress;
	}

	private void initProgress(class_8779 advancement, class_167 progress) {
		progress.method_727(advancement.comp_1920().comp_1916());
		this.progress.put(advancement, progress);
	}

	public void syncTo(class_3222 player) {
		assert this.server != null;

		for (class_8779 advancement : this.server.method_3851().method_12893()) {
			if (advancement.comp_1920().comp_1913().isEmpty() && !SharedAdvancements.config().shareDisplayless()) continue;

			class_167 progress = this.getProgress(advancement);

			progress.method_734().forEach(criterion -> player.method_14236().method_12878(advancement, criterion));
			progress.method_731().forEach(criterion -> player.method_14236().method_12883(advancement, criterion));
		}
	}

	public void loadProgressMap(ProgressMap progressMap) {
		assert this.server != null;
		class_2989 loader = this.server.method_3851();
		this.loadProgressMap(loader, progressMap);
	}


	private void loadProgressMap(class_2989 loader, ProgressMap progressMap) {
		progressMap.forEach((id, progress) -> {
			class_8779 advancementEntry = loader.method_12896(id);
			if (advancementEntry == null) {
				LOGGER.warn("Ignored advancement '{}' for group {} - it doesn't exist anymore?", id, this.getDisplayName());
				return;
			}
			this.initProgress(advancementEntry, progress);
			this.onStatusUpdate(advancementEntry);
		});
	}

	public ProgressMap createProgressMap() {
		LinkedHashMap<class_2960, class_167> map = new LinkedHashMap<>();
		this.progress.forEach((entry, progress) -> {
			if (progress.method_742()) {
				map.put(entry.comp_1919(), progress);
			}
		});
		return new ProgressMap(map);
	}


	public record ProgressMap(Map<class_2960, class_167> map) {
		public static final ProgressMap EMPTY = new ProgressMap(Map.of());

		public static final Codec<ProgressMap> CODEC = Codec.unboundedMap(class_2960.field_25139, class_167.field_46080).xmap(ProgressMap::new, ProgressMap::map);

		public void forEach(BiConsumer<class_2960, class_167> consumer) {
			this.map.entrySet().stream().sorted(Map.Entry.comparingByValue()).forEach(entry -> consumer.accept(entry.getKey(), entry.getValue()));
		}
	}

}

