package com.boyonk.sharedadvancements;

import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_268;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

public class SharedAdvancements implements ModInitializer {

	public static final String NAMESPACE = "shared_advancements";
	public static final Logger LOGGER = LoggerFactory.getLogger("Shared Advancements");
	public static final String NBT_KEY = NAMESPACE + ":advancement_tracker";

	private static SharedAdvancementsConfig config = SharedAdvancementsConfig.load();

	@Override
	public void onInitialize() {
		ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> config = SharedAdvancementsConfig.load());
		ServerPlayConnectionEvents.JOIN.register(((handler, sender, server) -> getAdvancementTracker(handler.field_14140).ifPresent(tracker -> tracker.syncTo(handler.field_14140))));

	}

	public static SharedAdvancementsConfig config() {
		return config;
	}


	public static Optional<GroupAdvancementTracker> getAdvancementTracker(@NotNull class_3222 player) {
		class_268 team = player.method_5781();
		if (team != null) {
			return Optional.of(((AdvancementTrackerHolder) team).getAdvancementTracker());
		} else if (config().globalGroup()) {
			return Optional.of(((AdvancementTrackerHolder) player.method_51469().method_8503().method_3845()).getAdvancementTracker());
		} else return Optional.empty();
	}

}
