package com.boyonk.sharedadvancements.mixin;

import com.boyonk.sharedadvancements.SharedAdvancement;
import com.boyonk.sharedadvancements.SharedAdvancements;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_161;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_161.class)
public class AdvancementMixin implements SharedAdvancement {


	@Unique
	private boolean sharedadvancements$shared = true;


	@Mutable
	@Shadow
	@Final
	public static Codec<class_161> CODEC;

	@Inject(method = "<clinit>", at = @At("RETURN"))
	private static void sharedadvancements$modifyCodec(CallbackInfo ci) {
		CODEC = Codec.pair(
				CODEC,
				RecordCodecBuilder.<Boolean>create(instance -> instance.group(
								Codec.BOOL
										.optionalFieldOf(SharedAdvancements.NAMESPACE + ":shared", true)
										.forGetter(bool -> bool)
						).apply(instance, bool -> bool)
				)
		).xmap(pair -> {
			class_161 advancement = pair.getFirst();
			((SharedAdvancement) (Object) advancement)._shared(pair.getSecond());
			return advancement;
		}, advancement -> Pair.of(advancement, ((SharedAdvancement) (Object) advancement).shared()));
	}

	@Override
	public boolean shared() {
		return this.sharedadvancements$shared;
	}

	@Override
	public void _shared(boolean shared) {
		this.sharedadvancements$shared = shared;
	}

	@ModifyReturnValue(method = "equals", at = @At("RETURN"))
	boolean sharevancements$equals(boolean original, @Local(argsOnly = true) Object object) {
		if (!original) return false;
		return ((SharedAdvancement) object).shared() == this.shared();
	}
}
