package com.boyonk.sharedadvancements.mixin;

import com.boyonk.sharedadvancements.SharedAdvancements;
import net.minecraft.class_185;
import net.minecraft.class_2985;
import net.minecraft.class_3222;
import net.minecraft.class_8779;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2985.class)
public class PlayerAdvancementTrackerMixin {


	@Shadow
	private class_3222 owner;

	@Inject(method = "grantCriterion", at = @At("HEAD"), cancellable = true)
	void sharevancements$grantCriterion(class_8779 advancement, String criterionName, CallbackInfoReturnable<Boolean> cir) {
		if ((this.owner.method_68878() || this.owner.method_7325()) && !SharedAdvancements.config().creativeDisabled()) {
			cir.setReturnValue(false);
			return;
		}

		SharedAdvancements.getAdvancementTracker(this.owner).ifPresent(tracker -> tracker.grantCriterion(advancement, criterionName, this.owner));

	}

	@Inject(method = "revokeCriterion", at = @At("HEAD"))
	void sharevancements$revokeCriterion(class_8779 advancement, String criterionName, CallbackInfoReturnable<Boolean> cir) {
		SharedAdvancements.getAdvancementTracker(this.owner).ifPresent(tracker -> tracker.revokeCriterion(advancement, criterionName, this.owner));
	}

	@Inject(method = "method_53637(Lnet/minecraft/advancement/AdvancementEntry;Lnet/minecraft/advancement/AdvancementDisplay;)V", at = @At(value = "HEAD"), cancellable = true)
	void sharevancements$shouldAnnounceToChat(class_8779 advancementEntry, class_185 display, CallbackInfo ci) {
		if (SharedAdvancements.getAdvancementTracker(this.owner).isPresent() && SharedAdvancements.config().mergeBroadcastMessage()) ci.cancel();
	}
}
