package com.boyonk.sharedadvancements.mixin;

import com.boyonk.sharedadvancements.GroupAdvancementTracker;
import com.boyonk.sharedadvancements.ProgressMapHolder;
import com.boyonk.sharedadvancements.SharedAdvancements;
import com.boyonk.sharedadvancements.mixin.ScoreboardState.PackedMixin;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Function;
import net.minecraft.class_273;

@Mixin(class_273.class_10745.class)
public class ScoreboardState$PackedMixin implements ProgressMapHolder {

	@Mutable
	@Shadow
	@Final
	public static Codec<class_273.class_10745> CODEC;

	@Unique
	private GroupAdvancementTracker.ProgressMap sharedadvancements$progressMap = GroupAdvancementTracker.ProgressMap.EMPTY;


	@Inject(method = "<clinit>", at = @At("RETURN"))
	private static void sharedadvancements$clinit(CallbackInfo ci) {
		Codec<GroupAdvancementTracker.ProgressMap> codec = RecordCodecBuilder.create(instance -> instance.group(
						GroupAdvancementTracker.ProgressMap.CODEC.optionalFieldOf(SharedAdvancements.NBT_KEY, GroupAdvancementTracker.ProgressMap.EMPTY).forGetter(Function.identity())
				).apply(instance, Function.identity())
		);

		CODEC = Codec.pair(
				CODEC,
				codec
		).xmap(pair -> {
			class_273.class_10745 packed = pair.getFirst();
			((PackedMixin) (Object) packed).sharedadvancements$progressMap = pair.getSecond();
			return packed;
		}, packed -> Pair.of(packed, ((PackedMixin) (Object) packed).sharedadvancements$progressMap));
	}

	@ModifyReturnValue(method = "equals", at = @At("RETURN"))
	boolean sharedadvancements$equals(boolean original, @Local(argsOnly = true) Object object) {
		if (!original) return false;
		return ((PackedMixin) object).sharedadvancements$progressMap == this.progressMap();

	}

	@Override
	public void progressMap(GroupAdvancementTracker.ProgressMap progressMap) {
		this.sharedadvancements$progressMap = progressMap;
	}

	@Override
	public GroupAdvancementTracker.ProgressMap progressMap() {
		return this.sharedadvancements$progressMap;
	}
}
