package com.boyonk.sharedadvancements.mixin;

import com.boyonk.sharedadvancements.AdvancementTrackerHolder;
import com.boyonk.sharedadvancements.GlobalAdvancementTracker;
import com.boyonk.sharedadvancements.GroupAdvancementTracker;
import net.minecraft.class_268;
import net.minecraft.class_2995;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_2995.class)
public class ServerScoreboardMixin implements AdvancementTrackerHolder {


	@Shadow
	@Final
	private MinecraftServer server;

	@Unique
	@Nullable
	private GroupAdvancementTracker sharedadvancements$advancementTracker = null;

	@Inject(method = "<init>", at = @At("RETURN"))
	void sharedadvancements$init(MinecraftServer server, CallbackInfo ci) {
		this.sharedadvancements$advancementTracker = new GlobalAdvancementTracker(server);
	}

	@Inject(method = "addScoreHolderToTeam", at = @At(value = "INVOKE", target = "Lnet/minecraft/server/PlayerManager;sendToAll(Lnet/minecraft/network/packet/Packet;)V", shift = At.Shift.AFTER))
	void sharevancements$addScoreHolderToTeam(String playerName, class_268 team, CallbackInfoReturnable<Boolean> cir) {
		class_3222 player = this.server.method_3760().method_14566(playerName);
		if (player != null) {
			((AdvancementTrackerHolder) team).getAdvancementTracker().syncTo(player);
		}
	}

	@Override
	public GroupAdvancementTracker getAdvancementTracker() {
		return this.sharedadvancements$advancementTracker;
	}
}
