package com.boyonk.sharedadvancements.mixin;

import com.boyonk.sharedadvancements.AdvancementTrackerHolder;
import com.boyonk.sharedadvancements.GroupAdvancementTracker;
import com.boyonk.sharedadvancements.ProgressMapHolder;
import com.boyonk.sharedadvancements.TeamAdvancementTracker;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2995;

@Mixin(class_268.class)
public class TeamMixin implements AdvancementTrackerHolder {

	@Unique
	@Nullable
	private GroupAdvancementTracker sharedadvancements$advancementTracker = null;

	@Inject(method = "<init>", at = @At("RETURN"))
	void sharedadvancements$init(class_269 scoreboard, String name, CallbackInfo ci) {
		if (scoreboard instanceof class_2995) {
			this.sharedadvancements$advancementTracker = new TeamAdvancementTracker((class_268) (Object) this, ((ServerScoreboardAccessor) scoreboard).getServer());
		}
	}

	@Override
	public GroupAdvancementTracker getAdvancementTracker() {
		return Objects.requireNonNull(this.sharedadvancements$advancementTracker, "Can't request TeamAdvancementTracker on client-side");
	}

	@ModifyReturnValue(method = "pack", at = @At("RETURN"))
	class_268.class_10743 sharedadvancements$pack(class_268.class_10743 original) {
		((ProgressMapHolder) (Object) original).progressMap(this.getAdvancementTracker().createProgressMap());
		return original;
	}



}
