/*
 * Decompiled with CFR 0.152.
 */
package com.misterxycb.enderite.init;

import com.misterxycb.enderite.init.BlockInit;
import com.misterxycb.enderite.items.BeaconBaseBlockItem;
import com.misterxycb.enderite.items.ModArmorMaterial;
import com.misterxycb.enderite.items.ModItemTier;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.flag.FeatureFlag;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SmithingTemplateItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ItemInit {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"misterxycb_enderite");
    public static final RegistryObject<Item> ENDERITE_INGOT = ITEMS.register("enderite_ingot", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> ENDERITE_PART = ITEMS.register("enderite_part", () -> new Item(new Item.Properties()));
    public static final RegistryObject<Item> ENDERITE_BLOCK_ITEM = ITEMS.register("enderite_block", () -> new BlockItem((Block)BlockInit.ENDERITE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> COMPRESSED_ENDER_ITEM = ITEMS.register("compressed_ender", () -> new BlockItem((Block)BlockInit.COMPRESSED_ENDER.get(), new Item.Properties()));
    public static final RegistryObject<Item> BEACON_BASE_BLOCK_ITEM = ITEMS.register("beacon_base_block", () -> new BeaconBaseBlockItem((Block)BlockInit.BEACON_BASE_BLOCK.get(), new Item.Properties()));
    public static final RegistryObject<Item> ENDERITE_SWORD = ITEMS.register("enderite_sword", () -> new SwordItem(ModItemTier.ENDERITE, new Item.Properties().attributes(SwordItem.createAttributes((Tier)ModItemTier.ENDERITE, (int)4, (float)-2.4f))));
    public static final RegistryObject<Item> ENDERITE_PICKAXE = ITEMS.register("enderite_pickaxe", () -> new PickaxeItem(ModItemTier.ENDERITE, new Item.Properties().attributes(PickaxeItem.createAttributes((Tier)ModItemTier.ENDERITE, (float)2.0f, (float)-2.8f))));
    public static final RegistryObject<Item> ENDERITE_AXE = ITEMS.register("enderite_axe", () -> new AxeItem(ModItemTier.ENDERITE, new Item.Properties().attributes(AxeItem.createAttributes((Tier)ModItemTier.ENDERITE, (float)5.0f, (float)-2.9f))));
    public static final RegistryObject<Item> ENDERITE_SHOVEL = ITEMS.register("enderite_shovel", () -> new ShovelItem(ModItemTier.ENDERITE, new Item.Properties().attributes(ShovelItem.createAttributes((Tier)ModItemTier.ENDERITE, (float)2.5f, (float)-3.0f))));
    public static final RegistryObject<Item> ENDERITE_HOE = ITEMS.register("enderite_hoe", () -> new HoeItem(ModItemTier.ENDERITE, new Item.Properties().attributes(HoeItem.createAttributes((Tier)ModItemTier.ENDERITE, (float)-4.0f, (float)-0.0f))));
    public static final RegistryObject<Item> ENDERITE_HELMET = ITEMS.register("enderite_helmet", () -> new ArmorItem(ModArmorMaterial.ENDERITE, ArmorItem.Type.HELMET, new Item.Properties().durability(ArmorItem.Type.HELMET.getDurability(44))));
    public static final RegistryObject<Item> ENDERITE_CHESTPLATE = ITEMS.register("enderite_chestplate", () -> new ArmorItem(ModArmorMaterial.ENDERITE, ArmorItem.Type.CHESTPLATE, new Item.Properties().durability(ArmorItem.Type.CHESTPLATE.getDurability(44))));
    public static final RegistryObject<Item> ENDERITE_LEGGINGS = ITEMS.register("enderite_leggings", () -> new ArmorItem(ModArmorMaterial.ENDERITE, ArmorItem.Type.LEGGINGS, new Item.Properties().durability(ArmorItem.Type.LEGGINGS.getDurability(44))));
    public static final RegistryObject<Item> ENDERITE_BOOTS = ITEMS.register("enderite_boots", () -> new ArmorItem(ModArmorMaterial.ENDERITE, ArmorItem.Type.BOOTS, new Item.Properties().durability(ArmorItem.Type.BOOTS.getDurability(44))));
    private static final Component ENDERITE_ARMOR_UPGRADE_APPLIES_TO = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"smithing_template.enderite_armor_upgrade.applies_to"))).withStyle(ChatFormatting.BLUE);
    private static final Component ENDERITE_TOOL_UPGRADE_APPLIES_TO = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"smithing_template.enderite_tool_upgrade.applies_to"))).withStyle(ChatFormatting.BLUE);
    private static final Component ENDERITE_UPGRADE_APPLIES_TO = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"smithing_template.enderite_upgrade_template.applies_to"))).withStyle(ChatFormatting.BLUE);
    private static final Component ENDERITE_UPGRADE_INGREDIENTS = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"smithing_template.enderite_upgrade.ingredients"))).withStyle(ChatFormatting.BLUE);
    private static final Component ENDERITE_UPGRADE_TEMPLATE_INGREDIENTS = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"smithing_template.enderite_upgrade_template.ingredients"))).withStyle(ChatFormatting.BLUE);
    private static final Component ENDERITE_ARMOR_UPGRADE = Component.translatable((String)Util.makeDescriptionId((String)"upgrade", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"enderite_armor_upgrade"))).withStyle(ChatFormatting.GRAY);
    private static final Component ENDERITE_TOOL_UPGRADE = Component.translatable((String)Util.makeDescriptionId((String)"upgrade", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"enderite_tool_upgrade"))).withStyle(ChatFormatting.GRAY);
    private static final Component ENDERITE_UPGRADE_TEMPLATE = Component.translatable((String)Util.makeDescriptionId((String)"upgrade", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"enderite_upgrade_template"))).withStyle(ChatFormatting.GRAY);
    private static final Component ENDERITE_ARMOR_UPGRADE_BASE_SLOT_DESCRIPTION = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"smithing_template.enderite_armor_upgrade.base_slot_description")));
    private static final Component ENDERITE_TOOL_UPGRADE_BASE_SLOT_DESCRIPTION = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"smithing_template.enderite_tool_upgrade.base_slot_description")));
    private static final Component ENDERITE_UPGRADE_TEMPLATE_BASE_SLOT_DESCRIPTION = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"smithing_template.enderite_upgrade_template.base_slot_description")));
    private static final Component ENDERITE_UPGRADE_ADDITIONS_SLOT_DESCRIPTION = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"smithing_template.enderite_upgrade.additions_slot_description")));
    private static final Component ENDERITE_UPGRADE_TEMPLATE_ADDITIONS_SLOT_DESCRIPTION = Component.translatable((String)Util.makeDescriptionId((String)"item", (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)"smithing_template.enderite_upgrade_template.additions_slot_description")));
    public static final RegistryObject<Item> ENDERITE_ARMOR_UPGRADE_SMITHING_TEMPLATE = ITEMS.register("enderite_armor_upgrade_smithing_template", () -> new SmithingTemplateItem(ENDERITE_ARMOR_UPGRADE_APPLIES_TO, ENDERITE_UPGRADE_INGREDIENTS, ENDERITE_ARMOR_UPGRADE, ENDERITE_ARMOR_UPGRADE_BASE_SLOT_DESCRIPTION, ENDERITE_UPGRADE_ADDITIONS_SLOT_DESCRIPTION, ItemInit.createEnderiteArmorUpgradeIconList(), List.of(ResourceLocation.withDefaultNamespace((String)"item/empty_slot_ingot")), new FeatureFlag[0]));
    public static final RegistryObject<Item> ENDERITE_TOOL_UPGRADE_SMITHING_TEMPLATE = ITEMS.register("enderite_tool_upgrade_smithing_template", () -> new SmithingTemplateItem(ENDERITE_TOOL_UPGRADE_APPLIES_TO, ENDERITE_UPGRADE_INGREDIENTS, ENDERITE_TOOL_UPGRADE, ENDERITE_TOOL_UPGRADE_BASE_SLOT_DESCRIPTION, ENDERITE_UPGRADE_ADDITIONS_SLOT_DESCRIPTION, ItemInit.createEnderiteToolUpgradeIconList(), List.of(ResourceLocation.withDefaultNamespace((String)"item/empty_slot_ingot")), new FeatureFlag[0]));
    public static final RegistryObject<Item> ENDERITE_UPGRADE_SMITHING_TEMPLATE_TEMPLATE = ITEMS.register("enderite_upgrade_smithing_template_template", () -> new SmithingTemplateItem(ENDERITE_UPGRADE_APPLIES_TO, ENDERITE_UPGRADE_TEMPLATE_INGREDIENTS, ENDERITE_UPGRADE_TEMPLATE, ENDERITE_TOOL_UPGRADE_BASE_SLOT_DESCRIPTION, ENDERITE_UPGRADE_TEMPLATE_ADDITIONS_SLOT_DESCRIPTION, List.of(ResourceLocation.withDefaultNamespace((String)"item/empty_slot_smithing_template_netherite_upgrade")), List.of(ResourceLocation.withDefaultNamespace((String)"item/empty_slot_ingot")), new FeatureFlag[0]));

    private static List<ResourceLocation> createEnderiteArmorUpgradeIconList() {
        return List.of(ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_helmet"), ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_chestplate"), ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_leggings"), ResourceLocation.withDefaultNamespace((String)"item/empty_armor_slot_boots"));
    }

    private static List<ResourceLocation> createEnderiteToolUpgradeIconList() {
        return List.of(ResourceLocation.withDefaultNamespace((String)"item/empty_slot_sword"), ResourceLocation.withDefaultNamespace((String)"item/empty_slot_pickaxe"), ResourceLocation.withDefaultNamespace((String)"item/empty_slot_axe"), ResourceLocation.withDefaultNamespace((String)"item/empty_slot_shovel"), ResourceLocation.withDefaultNamespace((String)"item/empty_slot_hoe"));
    }
}

