/*
 * Decompiled with CFR 0.152.
 */
package com.misterxycb.enderite.world.feature;

import com.misterxycb.enderite.world.feature.ModConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> COMPRESSED_ENDER_ORE_PLACED = ModPlacedFeatures.registerKey("compressed_ender_ore_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, COMPRESSED_ENDER_ORE_PLACED, configuredFeatures.getOrThrow(ModConfiguredFeatures.COMPRESSED_ENDER_ORE_KEY), ModPlacedFeatures.commonOrePlacement(7, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.aboveBottom((int)25), (VerticalAnchor)VerticalAnchor.aboveBottom((int)45))));
    }

    public static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"misterxycb_enderite", (String)name));
    }

    public static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }

    public static List<PlacementModifier> orePlacement(PlacementModifier pCountPlacement, PlacementModifier pHeightRange) {
        return List.of(pCountPlacement, InSquarePlacement.spread(), pHeightRange, BiomeFilter.biome());
    }

    public static List<PlacementModifier> commonOrePlacement(int pCount, PlacementModifier pHeightRange) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)CountPlacement.of((int)pCount), pHeightRange);
    }

    public static List<PlacementModifier> rareOrePlacement(int pCount, PlacementModifier pHeightRange) {
        return ModPlacedFeatures.orePlacement((PlacementModifier)RarityFilter.onAverageOnceEvery((int)pCount), pHeightRange);
    }
}

