/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.uniforms;

import java.util.Objects;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.gl.uniform.UniformHolder;
import net.irisshaders.iris.gl.uniform.UniformUpdateFrequency;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.uniforms.CapturedRenderingState;
import net.minecraft.class_11743;
import net.minecraft.class_12206;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;
import org.joml.Vector4f;

public final class CelestialUniforms {
    private static final Vector4f ZERO = new Vector4f();
    private final float sunPathRotation;

    public CelestialUniforms(float sunPathRotation) {
        this.sunPathRotation = sunPathRotation;
    }

    public static float getSunAngle(boolean sun) {
        float currentAngle = ((Float)class_310.method_1551().field_1773.method_19418().method_75756().method_75689(sun ? class_12206.field_64340 : class_12206.field_64341, CapturedRenderingState.INSTANCE.getTickDelta())).floatValue();
        float c = currentAngle + 90.0f;
        if (c < 0.0f) {
            c += 360.0f;
        } else if (c > 360.0f) {
            c -= 360.0f;
        }
        return c;
    }

    private static float getShadowAngle() {
        float shadowAngle = CelestialUniforms.getSunAngle(CelestialUniforms.isDay());
        return shadowAngle / 360.0f;
    }

    private static Vector4f getUpPosition() {
        Vector4f upVector = new Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f preCelestial = new Matrix4f(CapturedRenderingState.INSTANCE.getGbufferModelView());
        preCelestial.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
        upVector = preCelestial.transform(upVector);
        return upVector;
    }

    public static boolean isDay() {
        return class_310.method_1551().field_1687.method_8532() % 24000L < 12751L;
    }

    private static class_638 getWorld() {
        return Objects.requireNonNull(class_310.method_1551().field_1687);
    }

    public void addCelestialUniforms(UniformHolder uniforms) {
        uniforms.uniform1f(UniformUpdateFrequency.PER_FRAME, "sunAngle", () -> CelestialUniforms.getSunAngle(true) / 360.0f).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "sunPosition", this::getSunPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "moonPosition", this::getMoonPosition).uniform1f(UniformUpdateFrequency.PER_FRAME, "shadowAngle", CelestialUniforms::getShadowAngle).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "shadowLightPosition", this::getShadowLightPosition).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "endFlashPosition", () -> {
            if (class_310.method_1551().field_1687.method_27983() == class_1937.field_25181) {
                return this.getEndFlashPosition();
            }
            return ZERO;
        }).uniformTruncated3f(UniformUpdateFrequency.PER_FRAME, "upPosition", CelestialUniforms::getUpPosition);
    }

    private Vector4f getSunPosition() {
        return this.getCelestialPosition(true, 100.0f);
    }

    private Vector4f getMoonPosition() {
        return this.getCelestialPosition(false, -100.0f);
    }

    private Vector4f getEndFlashPosition() {
        class_11743 state = class_310.method_1551().field_1687.method_73229();
        float h = state.method_73239();
        float g = state.method_73236();
        Vector4f pos = new Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f m = new Matrix4f(CapturedRenderingState.INSTANCE.getGbufferModelView());
        m.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - h));
        m.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f - g));
        return m.transform(pos);
    }

    private Vector4f getEndFlashPositionInWorldSpace() {
        class_11743 state = class_310.method_1551().field_1687.method_73229();
        float h = state.method_73239();
        float g = state.method_73236();
        Vector4f pos = new Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f m = new Matrix4f();
        m.identity();
        m.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(180.0f - h));
        m.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f - g));
        return m.transform(pos);
    }

    public Vector4f getShadowLightPosition() {
        if (class_310.method_1551().field_1687.method_27983() == class_1937.field_25181 && Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::supportsEndFlash).orElse(false).booleanValue()) {
            return this.getEndFlashPosition();
        }
        return CelestialUniforms.isDay() ? this.getSunPosition() : this.getMoonPosition();
    }

    public Vector4f getShadowLightPositionInWorldSpace() {
        if (class_310.method_1551().field_1687.method_27983() == class_1937.field_25181 && Iris.getPipelineManager().getPipeline().map(WorldRenderingPipeline::supportsEndFlash).orElse(false).booleanValue()) {
            return this.getEndFlashPositionInWorldSpace();
        }
        return CelestialUniforms.isDay() ? this.getCelestialPositionInWorldSpace(true, 100.0f) : this.getCelestialPositionInWorldSpace(false, -100.0f);
    }

    private Vector4f getCelestialPositionInWorldSpace(boolean sun, float y) {
        Vector4f position = new Vector4f(0.0f, 100.0f, 0.0f, 0.0f);
        Matrix4f celestial = new Matrix4f();
        celestial.identity();
        celestial.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
        celestial.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.sunPathRotation));
        float currentAngle = ((Float)class_310.method_1551().field_1773.method_19418().method_75756().method_75689(sun ? class_12206.field_64340 : class_12206.field_64341, CapturedRenderingState.INSTANCE.getTickDelta())).floatValue();
        celestial.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(currentAngle));
        celestial.transform(position);
        return position;
    }

    private Vector4f getCelestialPosition(boolean sun, float y) {
        Vector4f position = new Vector4f(0.0f, 100.0f, 0.0f, 1.0f);
        Matrix4f celestial = new Matrix4f(CapturedRenderingState.INSTANCE.getGbufferModelView());
        celestial.rotate((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
        celestial.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.sunPathRotation));
        float currentAngle = ((Float)class_310.method_1551().field_1773.method_19418().method_75756().method_75689(sun ? class_12206.field_64340 : class_12206.field_64341, CapturedRenderingState.INSTANCE.getTickDelta())).floatValue();
        celestial.rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(currentAngle));
        position = celestial.transform(position);
        return position;
    }
}

