/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.autowhitelistremove;

import java.io.File;
import lol.hyper.autowhitelistremove.command.CommandAWR;
import lol.hyper.autowhitelistremove.hyperlib.HyperLib;
import lol.hyper.autowhitelistremove.hyperlib.bstats.HyperStats;
import lol.hyper.autowhitelistremove.hyperlib.releases.HyperUpdater;
import lol.hyper.autowhitelistremove.tools.WhitelistCheck;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class AutoWhitelistRemove
extends JavaPlugin {
    public final ComponentLogger logger = this.getComponentLogger();
    public final File configFile = new File(this.getDataFolder(), "config.yml");
    public final File removalsFile = new File(this.getDataFolder(), "removals.json");
    public FileConfiguration config;
    public WhitelistCheck whitelistCheck;
    public CommandAWR commandAWR;

    public void onEnable() {
        HyperLib hyperLib = new HyperLib((Plugin)this);
        hyperLib.setup();
        HyperStats stats = new HyperStats(hyperLib, 11684);
        stats.setup();
        this.whitelistCheck = new WhitelistCheck(this);
        this.commandAWR = new CommandAWR(this);
        this.getCommand("awr").setExecutor((CommandExecutor)this.commandAWR);
        this.loadConfig();
        if (this.config.getBoolean("autoremove-on-start")) {
            Bukkit.getGlobalRegionScheduler().runDelayed((Plugin)this, scheduledTask -> this.whitelistCheck.checkWhitelist(true), 50L);
        }
        HyperUpdater updater = new HyperUpdater(hyperLib);
        updater.setGitHub("hyperdefined", "AutoWhitelistRemove");
        updater.setModrinth("YLFgSRDy");
        updater.setHangar("AutoWhitelistRemove", "paper");
        updater.check();
    }

    public void loadConfig() {
        boolean isCorrect;
        if (!this.configFile.exists()) {
            this.saveResource("config.yml", true);
        }
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        int CONFIG_VERSION = 3;
        if (this.config.getInt("config-version") != CONFIG_VERSION) {
            this.logger.warn("Your configuration is out of date! Some features may not work!");
        }
        if (!(isCorrect = this.whitelistCheck.verifyTimeDuration(this.config.getString("inactive-period")))) {
            this.logger.warn("The time duration currently set is not valid! This will break everything!");
        }
    }
}

