/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.autowhitelistremove.command;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lol.hyper.autowhitelistremove.AutoWhitelistRemove;
import lol.hyper.autowhitelistremove.tools.WhitelistCheck;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class CommandAWR
implements TabExecutor {
    private final AutoWhitelistRemove autoWhitelistRemove;
    private final WhitelistCheck whitelistCheck;

    public CommandAWR(AutoWhitelistRemove autoWhitelistRemove) {
        this.autoWhitelistRemove = autoWhitelistRemove;
        this.whitelistCheck = autoWhitelistRemove.whitelistCheck;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String @NotNull [] args) {
        if (!sender.hasPermission("autowhitelistremove.command")) {
            sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
            return true;
        }
        if (args.length == 0) {
            sender.sendMessage((Component)Component.text((String)("AutoWhitelistRemove version " + this.autoWhitelistRemove.getPluginMeta().getVersion() + ". Created by hyperdefined."), (TextColor)NamedTextColor.GREEN));
            return true;
        }
        switch (args[0]) {
            case "check": {
                if (!sender.hasPermission("autowhitelistremove.check")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args.length == 2) {
                    if (!args[1].equalsIgnoreCase("confirm")) {
                        sender.sendMessage((Component)Component.text((String)"Invalid usage. See /awr help.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    if (!sender.hasPermission("autowhitelistremove.check.confirm")) {
                        sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    Set<String> removedPlayers = this.whitelistCheck.checkWhitelist(true);
                    sender.sendMessage((Component)Component.text((String)"--------------------AWR---------------------", (TextColor)NamedTextColor.GOLD));
                    if (removedPlayers.isEmpty()) {
                        sender.sendMessage((Component)Component.text((String)"No players to remove.", (TextColor)NamedTextColor.YELLOW));
                    } else {
                        sender.sendMessage((Component)Component.text((String)(removedPlayers.size() + " players have been removed."), (TextColor)NamedTextColor.YELLOW));
                        sender.sendMessage((Component)Component.text((String)String.join((CharSequence)", ", removedPlayers), (TextColor)NamedTextColor.YELLOW));
                    }
                    sender.sendMessage((Component)Component.text((String)"--------------------------------------------", (TextColor)NamedTextColor.GOLD));
                    return true;
                }
                Set<String> removedPlayers = this.whitelistCheck.checkWhitelist(false);
                sender.sendMessage((Component)Component.text((String)"--------------------AWR---------------------", (TextColor)NamedTextColor.GOLD));
                if (removedPlayers.isEmpty()) {
                    sender.sendMessage((Component)Component.text((String)"No players to remove.", (TextColor)NamedTextColor.YELLOW));
                } else {
                    sender.sendMessage((Component)Component.text((String)(removedPlayers.size() + " players will be removed. Type \"/awr check confirm\" to confirm the removal."), (TextColor)NamedTextColor.YELLOW));
                    sender.sendMessage((Component)Component.text((String)String.join((CharSequence)", ", removedPlayers), (TextColor)NamedTextColor.YELLOW));
                }
                sender.sendMessage((Component)Component.text((String)"--------------------------------------------", (TextColor)NamedTextColor.GOLD));
                break;
            }
            case "ignore": {
                if (!sender.hasPermission("autowhitelistremove.ignore")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.autoWhitelistRemove.logger.info(String.valueOf(args.length));
                if (args.length == 1) {
                    sender.sendMessage((Component)Component.text((String)"You must specify an action, 'add' or 'remove'.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                if (args[1].equalsIgnoreCase("add")) {
                    if (args.length == 2) {
                        sender.sendMessage((Component)Component.text((String)"You must specify a UUID to add.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    String toAdd = args[2];
                    try {
                        UUID temp = UUID.fromString(toAdd);
                        toAdd = temp.toString();
                    }
                    catch (IllegalArgumentException ignored) {
                        Player player = Bukkit.getPlayerExact((String)toAdd);
                        toAdd = player.getUniqueId().toString();
                    }
                    List ignoredPlayers = this.autoWhitelistRemove.config.getStringList("ignored-players");
                    if (ignoredPlayers.contains(toAdd)) {
                        sender.sendMessage((Component)Component.text((String)"This player is already ignored.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    ignoredPlayers.add(toAdd);
                    this.autoWhitelistRemove.config.set("ignored-players", (Object)ignoredPlayers);
                    try {
                        this.autoWhitelistRemove.config.save(this.autoWhitelistRemove.configFile);
                        sender.sendMessage((Component)Component.text((String)("Added UUID " + toAdd + " to whitelist."), (TextColor)NamedTextColor.GREEN));
                    }
                    catch (IOException exception) {
                        this.autoWhitelistRemove.logger.error("Unable to save config!", (Throwable)exception);
                    }
                    return true;
                }
                if (args[1].equalsIgnoreCase("remove")) {
                    if (args.length == 2) {
                        sender.sendMessage((Component)Component.text((String)"You must specify a UUID to remove.", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    String toRemove = args[2];
                    try {
                        UUID temp = UUID.fromString(toRemove);
                        toRemove = temp.toString();
                    }
                    catch (IllegalArgumentException ignored) {
                        Player player = Bukkit.getPlayerExact((String)toRemove);
                        toRemove = player.getUniqueId().toString();
                    }
                    List ignoredPlayers = this.autoWhitelistRemove.config.getStringList("ignored-players");
                    if (!ignoredPlayers.contains(toRemove)) {
                        sender.sendMessage((Component)Component.text((String)"This player is not ignored, can't remove", (TextColor)NamedTextColor.RED));
                        return true;
                    }
                    ignoredPlayers.remove(toRemove);
                    this.autoWhitelistRemove.config.set("ignored-players", (Object)ignoredPlayers);
                    try {
                        this.autoWhitelistRemove.config.save(this.autoWhitelistRemove.configFile);
                        sender.sendMessage((Component)Component.text((String)("Removed UUID " + toRemove + " from whitelist."), (TextColor)NamedTextColor.GREEN));
                    }
                    catch (IOException exception) {
                        this.autoWhitelistRemove.logger.error("Unable to save config!", (Throwable)exception);
                    }
                    return true;
                }
                sender.sendMessage((Component)Component.text((String)"This is not a valid action for 'ignore'.", (TextColor)NamedTextColor.RED));
                break;
            }
            case "reload": {
                if (!sender.hasPermission("autowhitelistremove.reload")) {
                    sender.sendMessage((Component)Component.text((String)"You do not have permission for this command.", (TextColor)NamedTextColor.RED));
                    return true;
                }
                this.autoWhitelistRemove.loadConfig();
                sender.sendMessage((Component)Component.text((String)"Config reloaded!", (TextColor)NamedTextColor.GREEN));
                break;
            }
            default: {
                sender.sendMessage(Component.text((String)"--------------------AWR---------------------").color((TextColor)NamedTextColor.GOLD));
                sender.sendMessage(Component.text((String)"/awr help ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"- Shows this menu.", (TextColor)NamedTextColor.YELLOW)));
                sender.sendMessage(Component.text((String)"/awr check ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"- Check inactive players and remove them.", (TextColor)NamedTextColor.YELLOW)));
                sender.sendMessage(Component.text((String)"/awr help ", (TextColor)NamedTextColor.GOLD).append((Component)Component.text((String)"- Reload the config.", (TextColor)NamedTextColor.YELLOW)));
                sender.sendMessage(Component.text((String)"--------------------------------------------").color((TextColor)NamedTextColor.GOLD));
            }
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 2 && args[0].equalsIgnoreCase("check") && sender.hasPermission("autowhitelistremove.check.confirm")) {
            return Collections.singletonList("confirm");
        }
        return Arrays.asList("check", "help", "reload");
    }
}

