/*
 * Decompiled with CFR 0.152.
 */
package lol.hyper.autowhitelistremove.hyperlib.releases;

import lol.hyper.autowhitelistremove.hyperlib.HyperLib;
import lol.hyper.autowhitelistremove.hyperlib.releases.github.GitHubPlugin;
import lol.hyper.autowhitelistremove.hyperlib.releases.github.GitHubRelease;
import lol.hyper.autowhitelistremove.hyperlib.releases.hangar.HangarPlugin;
import lol.hyper.autowhitelistremove.hyperlib.releases.hangar.HangarRelease;
import lol.hyper.autowhitelistremove.hyperlib.releases.modrinth.ModrinthPlugin;
import lol.hyper.autowhitelistremove.hyperlib.releases.modrinth.ModrinthRelease;
import org.bukkit.Bukkit;

public class HyperUpdater {
    private final HyperLib hyperLib;
    private String hangarID = null;
    private String hangarLoader = null;
    private String modrinthID = null;
    private String organization = null;
    private String repository = null;

    public HyperUpdater(HyperLib hyperLib) {
        this.hyperLib = hyperLib;
    }

    public void setHangar(String id, String loader) {
        this.hangarID = id;
        this.hangarLoader = loader;
    }

    public void setModrinth(String projectID) {
        this.modrinthID = projectID;
    }

    public void setGitHub(String organization, String repository) {
        this.organization = organization;
        this.repository = repository;
    }

    public void check() {
        Bukkit.getAsyncScheduler().runNow(this.hyperLib.getPlugin(), scheduledTask -> {
            HangarPlugin hangarPlugin = new HangarPlugin(this.hangarID, this.hangarLoader);
            hangarPlugin.get();
            ModrinthPlugin modrinthPlugin = new ModrinthPlugin(this.modrinthID);
            modrinthPlugin.get();
            GitHubPlugin gitHubPlugin = new GitHubPlugin(this.organization, this.repository);
            gitHubPlugin.get();
            String pluginVersion = this.hyperLib.getPlugin().getPluginMeta().getVersion();
            GitHubRelease currentGitHub = gitHubPlugin.getReleaseByVersion(pluginVersion);
            if (currentGitHub == null) {
                HyperLib.getPluginLogger().warn("Plugin version is not on GitHub!");
                return;
            }
            int buildsBehind = gitHubPlugin.buildsVersionsBehind(currentGitHub);
            if (buildsBehind == 0) {
                HyperLib.getPluginLogger().info("Yay! You are running the lates version!");
                return;
            }
            HangarRelease latestHangar = hangarPlugin.getLatestRelease();
            ModrinthRelease latestModrinth = modrinthPlugin.getLatestRelease();
            GitHubRelease latestGitHub = gitHubPlugin.getLatestRelease();
            HyperLib.getPluginLogger().warn("There are updates available! You are {} version(s) behind.", (Object)buildsBehind);
            HyperLib.getPluginLogger().warn("See the links below for the latest version ({})", (Object)latestGitHub.getVersion());
            HyperLib.getPluginLogger().warn(latestGitHub.getVersionPage());
            HyperLib.getPluginLogger().warn(latestModrinth.getVersionPage());
            HyperLib.getPluginLogger().warn(latestHangar.getVersionPage());
        });
    }
}

